<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models;

use stdClass;

/**
 * Additional attributes associated with the use of this Venmo Wallet.
 */
class VenmoWalletAdditionalAttributes implements \JsonSerializable
{
    /**
     * @var VenmoWalletCustomerInformation|null
     */
    private $customer;

    /**
     * @var VenmoWalletVaultAttributes|null
     */
    private $vault;

    /**
     * Returns Customer.
     * The details about a customer in PayPal's system of record.
     */
    public function getCustomer(): ?VenmoWalletCustomerInformation
    {
        return $this->customer;
    }

    /**
     * Sets Customer.
     * The details about a customer in PayPal's system of record.
     *
     * @maps customer
     */
    public function setCustomer(?VenmoWalletCustomerInformation $customer): void
    {
        $this->customer = $customer;
    }

    /**
     * Returns Vault.
     * Resource consolidating common request and response attirbutes for vaulting Venmo Wallet.
     */
    public function getVault(): ?VenmoWalletVaultAttributes
    {
        return $this->vault;
    }

    /**
     * Sets Vault.
     * Resource consolidating common request and response attirbutes for vaulting Venmo Wallet.
     *
     * @maps vault
     */
    public function setVault(?VenmoWalletVaultAttributes $vault): void
    {
        $this->vault = $vault;
    }

    /**
     * Encode this object to JSON
     *
     * @param bool $asArrayWhenEmpty Whether to serialize this model as an array whenever no fields
     *        are set. (default: false)
     *
     * @return array|stdClass
     */
    #[\ReturnTypeWillChange] // @phan-suppress-current-line PhanUndeclaredClassAttribute for (php < 8.1)
    public function jsonSerialize(bool $asArrayWhenEmpty = false)
    {
        $json = [];
        if (isset($this->customer)) {
            $json['customer'] = $this->customer;
        }
        if (isset($this->vault)) {
            $json['vault']    = $this->vault;
        }

        return (!$asArrayWhenEmpty && empty($json)) ? new stdClass() : $json;
    }
}
