<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models;

use stdClass;

/**
 * Payer confirms the intent to pay for the Order using the provided payment source.
 */
class ConfirmOrderRequest implements \JsonSerializable
{
    /**
     * @var PaymentSource
     */
    private $paymentSource;

    /**
     * @var mixed
     */
    private $processingInstruction;

    /**
     * @var OrderConfirmApplicationContext|null
     */
    private $applicationContext;

    /**
     * @param PaymentSource $paymentSource
     */
    public function __construct(PaymentSource $paymentSource)
    {
        $this->paymentSource = $paymentSource;
    }

    /**
     * Returns Payment Source.
     * The payment source definition.
     */
    public function getPaymentSource(): PaymentSource
    {
        return $this->paymentSource;
    }

    /**
     * Sets Payment Source.
     * The payment source definition.
     *
     * @required
     * @maps payment_source
     */
    public function setPaymentSource(PaymentSource $paymentSource): void
    {
        $this->paymentSource = $paymentSource;
    }

    /**
     * Returns Processing Instruction.
     *
     * @return mixed
     */
    public function getProcessingInstruction()
    {
        return $this->processingInstruction;
    }

    /**
     * Sets Processing Instruction.
     *
     * @maps processing_instruction
     *
     * @param mixed $processingInstruction
     */
    public function setProcessingInstruction($processingInstruction): void
    {
        $this->processingInstruction = $processingInstruction;
    }

    /**
     * Returns Application Context.
     * Customizes the payer confirmation experience.
     */
    public function getApplicationContext(): ?OrderConfirmApplicationContext
    {
        return $this->applicationContext;
    }

    /**
     * Sets Application Context.
     * Customizes the payer confirmation experience.
     *
     * @maps application_context
     */
    public function setApplicationContext(?OrderConfirmApplicationContext $applicationContext): void
    {
        $this->applicationContext = $applicationContext;
    }

    /**
     * Encode this object to JSON
     *
     * @param bool $asArrayWhenEmpty Whether to serialize this model as an array whenever no fields
     *        are set. (default: false)
     *
     * @return array|stdClass
     */
    #[\ReturnTypeWillChange] // @phan-suppress-current-line PhanUndeclaredClassAttribute for (php < 8.1)
    public function jsonSerialize(bool $asArrayWhenEmpty = false)
    {
        $json = [];
        $json['payment_source']             = $this->paymentSource;
        if (isset($this->processingInstruction)) {
            $json['processing_instruction'] = $this->processingInstruction;
        }
        if (isset($this->applicationContext)) {
            $json['application_context']    = $this->applicationContext;
        }

        return (!$asArrayWhenEmpty && empty($json)) ? new stdClass() : $json;
    }
}
