<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\OrderTrackerRequest;

/**
 * Builder for model OrderTrackerRequest
 *
 * @see OrderTrackerRequest
 */
class OrderTrackerRequestBuilder
{
    /**
     * @var OrderTrackerRequest
     */
    private $instance;

    private function __construct(OrderTrackerRequest $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new order tracker request Builder object.
     */
    public static function init(string $captureId): self
    {
        return new self(new OrderTrackerRequest($captureId));
    }

    /**
     * Sets tracking number field.
     */
    public function trackingNumber(?string $value): self
    {
        $this->instance->setTrackingNumber($value);
        return $this;
    }

    /**
     * Sets carrier field.
     */
    public function carrier(?string $value): self
    {
        $this->instance->setCarrier($value);
        return $this;
    }

    /**
     * Sets carrier name other field.
     */
    public function carrierNameOther(?string $value): self
    {
        $this->instance->setCarrierNameOther($value);
        return $this;
    }

    /**
     * Sets notify payer field.
     */
    public function notifyPayer(?bool $value): self
    {
        $this->instance->setNotifyPayer($value);
        return $this;
    }

    /**
     * Sets items field.
     */
    public function items(?array $value): self
    {
        $this->instance->setItems($value);
        return $this;
    }

    /**
     * Initializes a new order tracker request object.
     */
    public function build(): OrderTrackerRequest
    {
        return CoreHelper::clone($this->instance);
    }
}
