<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\Address;
use PaypalServerSdkLib\Models\ApplePayTokenizedCard;

/**
 * Builder for model ApplePayTokenizedCard
 *
 * @see ApplePayTokenizedCard
 */
class ApplePayTokenizedCardBuilder
{
    /**
     * @var ApplePayTokenizedCard
     */
    private $instance;

    private function __construct(ApplePayTokenizedCard $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new apple pay tokenized card Builder object.
     */
    public static function init(): self
    {
        return new self(new ApplePayTokenizedCard());
    }

    /**
     * Sets name field.
     */
    public function name(?string $value): self
    {
        $this->instance->setName($value);
        return $this;
    }

    /**
     * Sets number field.
     */
    public function number(?string $value): self
    {
        $this->instance->setNumber($value);
        return $this;
    }

    /**
     * Sets expiry field.
     */
    public function expiry(?string $value): self
    {
        $this->instance->setExpiry($value);
        return $this;
    }

    /**
     * Sets card type field.
     */
    public function cardType(?string $value): self
    {
        $this->instance->setCardType($value);
        return $this;
    }

    /**
     * Sets type field.
     */
    public function type(?string $value): self
    {
        $this->instance->setType($value);
        return $this;
    }

    /**
     * Sets brand field.
     */
    public function brand(?string $value): self
    {
        $this->instance->setBrand($value);
        return $this;
    }

    /**
     * Sets billing address field.
     */
    public function billingAddress(?Address $value): self
    {
        $this->instance->setBillingAddress($value);
        return $this;
    }

    /**
     * Initializes a new apple pay tokenized card object.
     */
    public function build(): ApplePayTokenizedCard
    {
        return CoreHelper::clone($this->instance);
    }
}
