<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\AddressDetails;
use PaypalServerSdkLib\Models\Name;
use PaypalServerSdkLib\Models\Phone;

/**
 * Builder for model AddressDetails
 *
 * @see AddressDetails
 */
class AddressDetailsBuilder
{
    /**
     * @var AddressDetails
     */
    private $instance;

    private function __construct(AddressDetails $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new address details Builder object.
     */
    public static function init(string $countryCode): self
    {
        return new self(new AddressDetails($countryCode));
    }

    /**
     * Sets address line 1 field.
     */
    public function addressLine1(?string $value): self
    {
        $this->instance->setAddressLine1($value);
        return $this;
    }

    /**
     * Sets address line 2 field.
     */
    public function addressLine2(?string $value): self
    {
        $this->instance->setAddressLine2($value);
        return $this;
    }

    /**
     * Sets admin area 2 field.
     */
    public function adminArea2(?string $value): self
    {
        $this->instance->setAdminArea2($value);
        return $this;
    }

    /**
     * Sets admin area 1 field.
     */
    public function adminArea1(?string $value): self
    {
        $this->instance->setAdminArea1($value);
        return $this;
    }

    /**
     * Sets postal code field.
     */
    public function postalCode(?string $value): self
    {
        $this->instance->setPostalCode($value);
        return $this;
    }

    /**
     * Sets name field.
     */
    public function name(?Name $value): self
    {
        $this->instance->setName($value);
        return $this;
    }

    /**
     * Sets id field.
     */
    public function id(?string $value): self
    {
        $this->instance->setId($value);
        return $this;
    }

    /**
     * Sets company field.
     */
    public function company(?string $value): self
    {
        $this->instance->setCompany($value);
        return $this;
    }

    /**
     * Sets phone field.
     */
    public function phone(?string $value): self
    {
        $this->instance->setPhone($value);
        return $this;
    }

    /**
     * Sets phone number field.
     */
    public function phoneNumber(?Phone $value): self
    {
        $this->instance->setPhoneNumber($value);
        return $this;
    }

    /**
     * Initializes a new address details object.
     */
    public function build(): AddressDetails
    {
        return CoreHelper::clone($this->instance);
    }
}
