<?php //c2e211f6bd292c7ab5e8dfb6d5ff1e4e
/** @noinspection all */

namespace App\Models {

    use Database\Factories\BlacklistsFactory;
    use Database\Factories\JobMonitorFactory;
    use Illuminate\Database\Eloquent\Model;
    use Illuminate\Database\Eloquent\Relations\BelongsTo;
    use Illuminate\Database\Eloquent\Relations\BelongsToMany;
    use Illuminate\Database\Eloquent\Relations\HasMany;
    use Illuminate\Database\Eloquent\Relations\HasManyThrough;
    use Illuminate\Database\Eloquent\Relations\HasOne;
    use Illuminate\Database\Eloquent\Relations\MorphToMany;
    use Illuminate\Notifications\DatabaseNotification;
    use Illuminate\Notifications\DatabaseNotificationCollection;
    use Illuminate\Support\Carbon;
    use Illuminate\Support\Stringable;
    use Laravel\Sanctum\PersonalAccessToken;
    use LaravelIdea\Helper\App\Models\_IH_Admin_C;
    use LaravelIdea\Helper\App\Models\_IH_Admin_QB;
    use LaravelIdea\Helper\App\Models\_IH_Announcements_C;
    use LaravelIdea\Helper\App\Models\_IH_Announcements_QB;
    use LaravelIdea\Helper\App\Models\_IH_AppConfig_C;
    use LaravelIdea\Helper\App\Models\_IH_AppConfig_QB;
    use LaravelIdea\Helper\App\Models\_IH_Automation_C;
    use LaravelIdea\Helper\App\Models\_IH_Automation_QB;
    use LaravelIdea\Helper\App\Models\_IH_Blacklists_C;
    use LaravelIdea\Helper\App\Models\_IH_Blacklists_QB;
    use LaravelIdea\Helper\App\Models\_IH_BlockSenderId_C;
    use LaravelIdea\Helper\App\Models\_IH_BlockSenderId_QB;
    use LaravelIdea\Helper\App\Models\_IH_CampaignsList_C;
    use LaravelIdea\Helper\App\Models\_IH_CampaignsList_QB;
    use LaravelIdea\Helper\App\Models\_IH_CampaignsRecipients_C;
    use LaravelIdea\Helper\App\Models\_IH_CampaignsRecipients_QB;
    use LaravelIdea\Helper\App\Models\_IH_CampaignsSenderid_C;
    use LaravelIdea\Helper\App\Models\_IH_CampaignsSenderid_QB;
    use LaravelIdea\Helper\App\Models\_IH_CampaignsSendingServer_C;
    use LaravelIdea\Helper\App\Models\_IH_CampaignsSendingServer_QB;
    use LaravelIdea\Helper\App\Models\_IH_Campaigns_C;
    use LaravelIdea\Helper\App\Models\_IH_Campaigns_QB;
    use LaravelIdea\Helper\App\Models\_IH_ChatBoxMessage_C;
    use LaravelIdea\Helper\App\Models\_IH_ChatBoxMessage_QB;
    use LaravelIdea\Helper\App\Models\_IH_ChatBox_C;
    use LaravelIdea\Helper\App\Models\_IH_ChatBox_QB;
    use LaravelIdea\Helper\App\Models\_IH_ContactGroupFieldOptions_C;
    use LaravelIdea\Helper\App\Models\_IH_ContactGroupFieldOptions_QB;
    use LaravelIdea\Helper\App\Models\_IH_ContactGroupFields_C;
    use LaravelIdea\Helper\App\Models\_IH_ContactGroupFields_QB;
    use LaravelIdea\Helper\App\Models\_IH_ContactGroupsOptinKeywords_C;
    use LaravelIdea\Helper\App\Models\_IH_ContactGroupsOptinKeywords_QB;
    use LaravelIdea\Helper\App\Models\_IH_ContactGroupsOptoutKeywords_C;
    use LaravelIdea\Helper\App\Models\_IH_ContactGroupsOptoutKeywords_QB;
    use LaravelIdea\Helper\App\Models\_IH_ContactGroups_C;
    use LaravelIdea\Helper\App\Models\_IH_ContactGroups_QB;
    use LaravelIdea\Helper\App\Models\_IH_ContactsCustomField_C;
    use LaravelIdea\Helper\App\Models\_IH_ContactsCustomField_QB;
    use LaravelIdea\Helper\App\Models\_IH_Contacts_C;
    use LaravelIdea\Helper\App\Models\_IH_Contacts_QB;
    use LaravelIdea\Helper\App\Models\_IH_Country_C;
    use LaravelIdea\Helper\App\Models\_IH_Country_QB;
    use LaravelIdea\Helper\App\Models\_IH_CsvData_C;
    use LaravelIdea\Helper\App\Models\_IH_CsvData_QB;
    use LaravelIdea\Helper\App\Models\_IH_Currency_C;
    use LaravelIdea\Helper\App\Models\_IH_Currency_QB;
    use LaravelIdea\Helper\App\Models\_IH_CustomerBasedPricingPlan_C;
    use LaravelIdea\Helper\App\Models\_IH_CustomerBasedPricingPlan_QB;
    use LaravelIdea\Helper\App\Models\_IH_CustomerBasedSendingServer_C;
    use LaravelIdea\Helper\App\Models\_IH_CustomerBasedSendingServer_QB;
    use LaravelIdea\Helper\App\Models\_IH_Customer_C;
    use LaravelIdea\Helper\App\Models\_IH_Customer_QB;
    use LaravelIdea\Helper\App\Models\_IH_CustomSendingServer_C;
    use LaravelIdea\Helper\App\Models\_IH_CustomSendingServer_QB;
    use LaravelIdea\Helper\App\Models\_IH_EmailTemplates_C;
    use LaravelIdea\Helper\App\Models\_IH_EmailTemplates_QB;
    use LaravelIdea\Helper\App\Models\_IH_FailedContactImport_C;
    use LaravelIdea\Helper\App\Models\_IH_FailedContactImport_QB;
    use LaravelIdea\Helper\App\Models\_IH_FileCampaignData_C;
    use LaravelIdea\Helper\App\Models\_IH_FileCampaignData_QB;
    use LaravelIdea\Helper\App\Models\_IH_Invoices_C;
    use LaravelIdea\Helper\App\Models\_IH_Invoices_QB;
    use LaravelIdea\Helper\App\Models\_IH_JobMonitor_C;
    use LaravelIdea\Helper\App\Models\_IH_JobMonitor_QB;
    use LaravelIdea\Helper\App\Models\_IH_Job_C;
    use LaravelIdea\Helper\App\Models\_IH_Job_QB;
    use LaravelIdea\Helper\App\Models\_IH_Keywords_C;
    use LaravelIdea\Helper\App\Models\_IH_Keywords_QB;
    use LaravelIdea\Helper\App\Models\_IH_Language_C;
    use LaravelIdea\Helper\App\Models\_IH_Language_QB;
    use LaravelIdea\Helper\App\Models\_IH_Notifications_C;
    use LaravelIdea\Helper\App\Models\_IH_Notifications_QB;
    use LaravelIdea\Helper\App\Models\_IH_PaymentMethods_C;
    use LaravelIdea\Helper\App\Models\_IH_PaymentMethods_QB;
    use LaravelIdea\Helper\App\Models\_IH_Permission_C;
    use LaravelIdea\Helper\App\Models\_IH_Permission_QB;
    use LaravelIdea\Helper\App\Models\_IH_PhoneNumbers_C;
    use LaravelIdea\Helper\App\Models\_IH_PhoneNumbers_QB;
    use LaravelIdea\Helper\App\Models\_IH_PlansCoverageCountries_C;
    use LaravelIdea\Helper\App\Models\_IH_PlansCoverageCountries_QB;
    use LaravelIdea\Helper\App\Models\_IH_PlanSendingCreditPrice_C;
    use LaravelIdea\Helper\App\Models\_IH_PlanSendingCreditPrice_QB;
    use LaravelIdea\Helper\App\Models\_IH_Plan_C;
    use LaravelIdea\Helper\App\Models\_IH_Plan_QB;
    use LaravelIdea\Helper\App\Models\_IH_Plugins_C;
    use LaravelIdea\Helper\App\Models\_IH_Plugins_QB;
    use LaravelIdea\Helper\App\Models\_IH_Reports_C;
    use LaravelIdea\Helper\App\Models\_IH_Reports_QB;
    use LaravelIdea\Helper\App\Models\_IH_RoleUser_C;
    use LaravelIdea\Helper\App\Models\_IH_RoleUser_QB;
    use LaravelIdea\Helper\App\Models\_IH_Role_C;
    use LaravelIdea\Helper\App\Models\_IH_Role_QB;
    use LaravelIdea\Helper\App\Models\_IH_ScheduleMessage_C;
    use LaravelIdea\Helper\App\Models\_IH_ScheduleMessage_QB;
    use LaravelIdea\Helper\App\Models\_IH_SegmentConditions_C;
    use LaravelIdea\Helper\App\Models\_IH_SegmentConditions_QB;
    use LaravelIdea\Helper\App\Models\_IH_Segments_C;
    use LaravelIdea\Helper\App\Models\_IH_Segments_QB;
    use LaravelIdea\Helper\App\Models\_IH_SendCampaignSMS_C;
    use LaravelIdea\Helper\App\Models\_IH_SendCampaignSMS_QB;
    use LaravelIdea\Helper\App\Models\_IH_SenderidPlan_C;
    use LaravelIdea\Helper\App\Models\_IH_SenderidPlan_QB;
    use LaravelIdea\Helper\App\Models\_IH_Senderid_C;
    use LaravelIdea\Helper\App\Models\_IH_Senderid_QB;
    use LaravelIdea\Helper\App\Models\_IH_SendingServerBasedPricingPlans_C;
    use LaravelIdea\Helper\App\Models\_IH_SendingServerBasedPricingPlans_QB;
    use LaravelIdea\Helper\App\Models\_IH_SendingServer_C;
    use LaravelIdea\Helper\App\Models\_IH_SendingServer_QB;
    use LaravelIdea\Helper\App\Models\_IH_SpamWord_C;
    use LaravelIdea\Helper\App\Models\_IH_SpamWord_QB;
    use LaravelIdea\Helper\App\Models\_IH_SubscriptionLog_C;
    use LaravelIdea\Helper\App\Models\_IH_SubscriptionLog_QB;
    use LaravelIdea\Helper\App\Models\_IH_SubscriptionTransaction_C;
    use LaravelIdea\Helper\App\Models\_IH_SubscriptionTransaction_QB;
    use LaravelIdea\Helper\App\Models\_IH_Subscription_C;
    use LaravelIdea\Helper\App\Models\_IH_Subscription_QB;
    use LaravelIdea\Helper\App\Models\_IH_Templates_C;
    use LaravelIdea\Helper\App\Models\_IH_Templates_QB;
    use LaravelIdea\Helper\App\Models\_IH_TemplateTags_C;
    use LaravelIdea\Helper\App\Models\_IH_TemplateTags_QB;
    use LaravelIdea\Helper\App\Models\_IH_TrackingLog_C;
    use LaravelIdea\Helper\App\Models\_IH_TrackingLog_QB;
    use LaravelIdea\Helper\App\Models\_IH_User_C;
    use LaravelIdea\Helper\App\Models\_IH_User_QB;
    use LaravelIdea\Helper\Illuminate\Notifications\_IH_DatabaseNotification_QB;
    use LaravelIdea\Helper\Laravel\Sanctum\_IH_PersonalAccessToken_C;
    use LaravelIdea\Helper\Laravel\Sanctum\_IH_PersonalAccessToken_QB;
    
    /**
     * @property DatabaseNotificationCollection|DatabaseNotification[] $notifications
     * @property-read int $notifications_count
     * @method MorphToMany|_IH_DatabaseNotification_QB notifications()
     * @property DatabaseNotificationCollection|DatabaseNotification[] $readNotifications
     * @property-read int $read_notifications_count
     * @method MorphToMany|_IH_DatabaseNotification_QB readNotifications()
     * @property DatabaseNotificationCollection|DatabaseNotification[] $unreadNotifications
     * @property-read int $unread_notifications_count
     * @method MorphToMany|_IH_DatabaseNotification_QB unreadNotifications()
     * @method static _IH_Admin_QB onWriteConnection()
     * @method _IH_Admin_QB newQuery()
     * @method static _IH_Admin_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_Admin_QB query()
     * @method static _IH_Admin_QB with(array|string $relations)
     * @method _IH_Admin_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Admin_C|Admin[] all($columns = ['*'])
     * @mixin _IH_Admin_QB
     */
    class Admin extends Model {}
    
    /**
     * @property int $id
     * @property string $uid
     * @property int $user_id
     * @property string $title
     * @property string $description
     * @property string $type
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property _IH_User_C|User[] $users
     * @property-read int $users_count
     * @method BelongsToMany|_IH_User_QB users()
     * @method static _IH_Announcements_QB onWriteConnection()
     * @method _IH_Announcements_QB newQuery()
     * @method static _IH_Announcements_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_Announcements_QB query()
     * @method static _IH_Announcements_QB with(array|string $relations)
     * @method _IH_Announcements_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Announcements_C|Announcements[] all($columns = ['*'])
     * @ownLinks user_id,\App\Models\User,id
     * @foreignLinks 
     * @mixin _IH_Announcements_QB
     */
    class Announcements extends Model {}
    
    /**
     * @property int $id
     * @property string $setting
     * @property string|null $value
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_AppConfig_QB onWriteConnection()
     * @method _IH_AppConfig_QB newQuery()
     * @method static _IH_AppConfig_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_AppConfig_QB query()
     * @method static _IH_AppConfig_QB with(array|string $relations)
     * @method _IH_AppConfig_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_AppConfig_C|AppConfig[] all($columns = ['*'])
     * @mixin _IH_AppConfig_QB
     */
    class AppConfig extends Model {}
    
    /**
     * @property int $id
     * @property string $uid
     * @property string $name
     * @property int $user_id
     * @property int $contact_list_id
     * @property int|null $sending_server_id
     * @property string|null $timezone
     * @property string|null $sender_id
     * @property string|null $message
     * @property string|null $media_url
     * @property string|null $language
     * @property string|null $gender
     * @property string $sms_type
     * @property string|null $status
     * @property string|null $reason
     * @property string|null $cache
     * @property string $data
     * @property int|null $running_pid
     * @property string|null $dlt_template_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property string|null $last_error
     * @property ContactGroups $contactList
     * @method BelongsTo|_IH_ContactGroups_QB contactList()
     * @property Customer $customer
     * @method BelongsTo|_IH_Customer_QB customer()
     * @property _IH_JobMonitor_C|JobMonitor[] $jobMonitors
     * @property-read int $job_monitors_count
     * @method HasMany|_IH_JobMonitor_QB jobMonitors()
     * @property _IH_Reports_C|Reports[] $reports
     * @property-read int $reports_count
     * @method HasMany|_IH_Reports_QB reports()
     * @property SendingServer|null $sendingServer
     * @method BelongsTo|_IH_SendingServer_QB sendingServer()
     * @property _IH_TrackingLog_C|TrackingLog[] $trackingLogs
     * @property-read int $tracking_logs_count
     * @method HasMany|_IH_TrackingLog_QB trackingLogs()
     * @property User $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_Automation_QB onWriteConnection()
     * @method _IH_Automation_QB newQuery()
     * @method static _IH_Automation_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_Automation_QB query()
     * @method static _IH_Automation_QB with(array|string $relations)
     * @method _IH_Automation_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Automation_C|Automation[] all($columns = ['*'])
     * @ownLinks user_id,\App\Models\User,id|contact_list_id,\App\Models\ContactGroups,id|sending_server_id,\App\Models\SendingServer,id|sending_server_id,\App\Models\SendingServer,id
     * @foreignLinks id,\App\Models\TrackingLog,automation_id|id,\App\Models\Reports,automation_id
     * @mixin _IH_Automation_QB
     */
    class Automation extends Model {}
    
    /**
     * @property int $id
     * @property string $uid
     * @property int|null $user_id
     * @property string $number
     * @property string|null $reason
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property User|null $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_Blacklists_QB onWriteConnection()
     * @method _IH_Blacklists_QB newQuery()
     * @method static _IH_Blacklists_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_Blacklists_QB query()
     * @method static _IH_Blacklists_QB with(array|string $relations)
     * @method _IH_Blacklists_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Blacklists_C|Blacklists[] all($columns = ['*'])
     * @ownLinks user_id,\App\Models\User,id
     * @mixin _IH_Blacklists_QB
     * @method static BlacklistsFactory factory(callable|int|mixed[]|null $count = null, callable|mixed[] $state = [])
     */
    class Blacklists extends Model {}
    
    /**
     * @property int $id
     * @property string $uid
     * @property string $sender_id
     * @property string|null $reason
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_BlockSenderId_QB onWriteConnection()
     * @method _IH_BlockSenderId_QB newQuery()
     * @method static _IH_BlockSenderId_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_BlockSenderId_QB query()
     * @method static _IH_BlockSenderId_QB with(array|string $relations)
     * @method _IH_BlockSenderId_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_BlockSenderId_C|BlockSenderId[] all($columns = ['*'])
     * @mixin _IH_BlockSenderId_QB
     */
    class BlockSenderId extends Model {}
    
    /**
     * @property int $id
     * @property string $uid
     * @property int $user_id
     * @property string|null $campaign_name
     * @property string|null $message
     * @property string|null $media_url
     * @property string|null $language
     * @property string|null $gender
     * @property string $sms_type
     * @property string $upload_type
     * @property string|null $status
     * @property string|null $reason
     * @property string|null $api_key
     * @property string|null $cache
     * @property string|null $timezone
     * @property Carbon|null $schedule_time
     * @property string|null $schedule_type
     * @property string|null $frequency_cycle
     * @property int|null $frequency_amount
     * @property string|null $frequency_unit
     * @property Carbon|null $recurring_end
     * @property Carbon|null $run_at
     * @property Carbon|null $delivery_at
     * @property string|null $batch_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property int|null $running_pid
     * @property string|null $dlt_template_id
     * @property bool $skip_failed_message
     * @property bool $recurring_created
     * @property int|null $sending_server_id
     * @property string|null $last_error
     * @property _IH_CampaignsList_C|CampaignsList[] $contactList
     * @property-read int $contact_list_count
     * @method HasMany|_IH_CampaignsList_QB contactList()
     * @property Customer $customer
     * @method BelongsTo|_IH_Customer_QB customer()
     * @property _IH_JobMonitor_C|JobMonitor[] $jobMonitors
     * @property-read int $job_monitors_count
     * @method HasMany|_IH_JobMonitor_QB jobMonitors()
     * @property _IH_CampaignsRecipients_C|CampaignsRecipients[] $recipients
     * @property-read int $recipients_count
     * @method HasMany|_IH_CampaignsRecipients_QB recipients()
     * @property _IH_Reports_C|Reports[] $reports
     * @property-read int $reports_count
     * @method HasMany|_IH_Reports_QB reports()
     * @property _IH_CampaignsSenderid_C|CampaignsSenderid[] $senderids
     * @property-read int $senderids_count
     * @method HasMany|_IH_CampaignsSenderid_QB senderids()
     * @property SendingServer|null $sendingServer
     * @method BelongsTo|_IH_SendingServer_QB sendingServer()
     * @property User $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_Campaigns_QB onWriteConnection()
     * @method _IH_Campaigns_QB newQuery()
     * @method static _IH_Campaigns_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_Campaigns_QB query()
     * @method static _IH_Campaigns_QB with(array|string $relations)
     * @method _IH_Campaigns_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Campaigns_C|Campaigns[] all($columns = ['*'])
     * @ownLinks user_id,\App\Models\User,id|sending_server_id,\App\Models\SendingServer,id
     * @foreignLinks id,\App\Models\Reports,campaign_id|id,\App\Models\CampaignsList,campaign_id|id,\App\Models\CampaignsSenderid,campaign_id|id,\App\Models\TrackingLog,campaign_id|id,\App\Models\FileCampaignData,campaign_id
     * @mixin _IH_Campaigns_QB
     */
    class Campaigns extends Model {}
    
    /**
     * @property int $id
     * @property int $campaign_id
     * @property int $contact_list_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Campaigns $campaign
     * @method BelongsTo|_IH_Campaigns_QB campaign()
     * @property _IH_ContactGroups_C|ContactGroups[] $contactGroups
     * @property-read int $contact_groups_count
     * @method HasMany|_IH_ContactGroups_QB contactGroups()
     * @property ContactGroups $contactList
     * @method BelongsTo|_IH_ContactGroups_QB contactList()
     * @method static _IH_CampaignsList_QB onWriteConnection()
     * @method _IH_CampaignsList_QB newQuery()
     * @method static _IH_CampaignsList_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_CampaignsList_QB query()
     * @method static _IH_CampaignsList_QB with(array|string $relations)
     * @method _IH_CampaignsList_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_CampaignsList_C|CampaignsList[] all($columns = ['*'])
     * @ownLinks campaign_id,\App\Models\Campaigns,id|contact_list_id,\App\Models\ContactGroups,id
     * @mixin _IH_CampaignsList_QB
     */
    class CampaignsList extends Model {}
    
    /**
     * @property Campaigns $campaign
     * @method BelongsTo|_IH_Campaigns_QB campaign()
     * @method static _IH_CampaignsRecipients_QB onWriteConnection()
     * @method _IH_CampaignsRecipients_QB newQuery()
     * @method static _IH_CampaignsRecipients_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_CampaignsRecipients_QB query()
     * @method static _IH_CampaignsRecipients_QB with(array|string $relations)
     * @method _IH_CampaignsRecipients_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_CampaignsRecipients_C|CampaignsRecipients[] all($columns = ['*'])
     * @mixin _IH_CampaignsRecipients_QB
     */
    class CampaignsRecipients extends Model {}
    
    /**
     * @property int $id
     * @property int $campaign_id
     * @property string $sender_id
     * @property string|null $originator
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Campaigns $campaign
     * @method BelongsTo|_IH_Campaigns_QB campaign()
     * @method static _IH_CampaignsSenderid_QB onWriteConnection()
     * @method _IH_CampaignsSenderid_QB newQuery()
     * @method static _IH_CampaignsSenderid_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_CampaignsSenderid_QB query()
     * @method static _IH_CampaignsSenderid_QB with(array|string $relations)
     * @method _IH_CampaignsSenderid_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_CampaignsSenderid_C|CampaignsSenderid[] all($columns = ['*'])
     * @ownLinks campaign_id,\App\Models\Campaigns,id
     * @mixin _IH_CampaignsSenderid_QB
     */
    class CampaignsSenderid extends Model {}
    
    /**
     * @property Campaigns $campaign
     * @method BelongsTo|_IH_Campaigns_QB campaign()
     * @method static _IH_CampaignsSendingServer_QB onWriteConnection()
     * @method _IH_CampaignsSendingServer_QB newQuery()
     * @method static _IH_CampaignsSendingServer_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_CampaignsSendingServer_QB query()
     * @method static _IH_CampaignsSendingServer_QB with(array|string $relations)
     * @method _IH_CampaignsSendingServer_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_CampaignsSendingServer_C|CampaignsSendingServer[] all($columns = ['*'])
     * @mixin _IH_CampaignsSendingServer_QB
     */
    class CampaignsSendingServer extends Model {}
    
    /**
     * @property int $id
     * @property string $uid
     * @property int $user_id
     * @property string|null $from
     * @property string $to
     * @property int|null $notification
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property int|null $sending_server_id
     * @property bool $reply_by_customer
     * @property bool $pinned
     * @property ChatBoxMessage $boxMessages
     * @method BelongsTo|_IH_ChatBoxMessage_QB boxMessages()
     * @property _IH_ChatBoxMessage_C|ChatBoxMessage[] $chatBoxMessages
     * @property-read int $chat_box_messages_count
     * @method HasMany|_IH_ChatBoxMessage_QB chatBoxMessages()
     * @property Contacts $contact
     * @method BelongsTo|_IH_Contacts_QB contact()
     * @method static _IH_ChatBox_QB onWriteConnection()
     * @method _IH_ChatBox_QB newQuery()
     * @method static _IH_ChatBox_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_ChatBox_QB query()
     * @method static _IH_ChatBox_QB with(array|string $relations)
     * @method _IH_ChatBox_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_ChatBox_C|ChatBox[] all($columns = ['*'])
     * @ownLinks user_id,\App\Models\User,id|sending_server_id,\App\Models\SendingServer,id
     * @foreignLinks id,\App\Models\ChatBoxMessage,box_id
     * @mixin _IH_ChatBox_QB
     */
    class ChatBox extends Model {}
    
    /**
     * @property int $id
     * @property int $box_id
     * @property string|null $message
     * @property string|null $media_url
     * @property string $sms_type
     * @property string|null $send_by
     * @property int|null $sending_server_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property string|null $direction
     * @property ChatBox $chatBox
     * @method BelongsTo|_IH_ChatBox_QB chatBox()
     * @method static _IH_ChatBoxMessage_QB onWriteConnection()
     * @method _IH_ChatBoxMessage_QB newQuery()
     * @method static _IH_ChatBoxMessage_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_ChatBoxMessage_QB query()
     * @method static _IH_ChatBoxMessage_QB with(array|string $relations)
     * @method _IH_ChatBoxMessage_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_ChatBoxMessage_C|ChatBoxMessage[] all($columns = ['*'])
     * @ownLinks box_id,\App\Models\ChatBox,id|sending_server_id,\App\Models\SendingServer,id
     * @mixin _IH_ChatBoxMessage_QB
     */
    class ChatBoxMessage extends Model {}
    
    /**
     * @property int $id
     * @property string $uid
     * @property int $field_id
     * @property string $label
     * @property string $value
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property ContactGroupFields $field
     * @method BelongsTo|_IH_ContactGroupFields_QB field()
     * @method static _IH_ContactGroupFieldOptions_QB onWriteConnection()
     * @method _IH_ContactGroupFieldOptions_QB newQuery()
     * @method static _IH_ContactGroupFieldOptions_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_ContactGroupFieldOptions_QB query()
     * @method static _IH_ContactGroupFieldOptions_QB with(array|string $relations)
     * @method _IH_ContactGroupFieldOptions_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_ContactGroupFieldOptions_C|ContactGroupFieldOptions[] all($columns = ['*'])
     * @ownLinks field_id,\App\Models\ContactGroupFields,id
     * @mixin _IH_ContactGroupFieldOptions_QB
     */
    class ContactGroupFieldOptions extends Model {}
    
    /**
     * @property int $id
     * @property string $uid
     * @property int $contact_group_id
     * @property string $label
     * @property string $type
     * @property string $tag
     * @property string|null $default_value
     * @property bool $visible
     * @property bool $required
     * @property bool $is_phone
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property ContactGroups $contactGroup
     * @method BelongsTo|_IH_ContactGroups_QB contactGroup()
     * @property _IH_ContactGroupFieldOptions_C|ContactGroupFieldOptions[] $fieldOptions
     * @property-read int $field_options_count
     * @method HasMany|_IH_ContactGroupFieldOptions_QB fieldOptions()
     * @method static _IH_ContactGroupFields_QB onWriteConnection()
     * @method _IH_ContactGroupFields_QB newQuery()
     * @method static _IH_ContactGroupFields_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_ContactGroupFields_QB query()
     * @method static _IH_ContactGroupFields_QB with(array|string $relations)
     * @method _IH_ContactGroupFields_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_ContactGroupFields_C|ContactGroupFields[] all($columns = ['*'])
     * @ownLinks contact_group_id,\App\Models\ContactGroups,id
     * @foreignLinks id,\App\Models\ContactGroupFieldOptions,field_id|id,\App\Models\ContactsCustomField,field_id|id,\App\Models\SegmentConditions,field_id
     * @mixin _IH_ContactGroupFields_QB
     */
    class ContactGroupFields extends Model {}
    
    /**
     * @property int $id
     * @property string $uid
     * @property int $customer_id
     * @property string $name
     * @property string|null $sender_id
     * @property bool $send_welcome_sms
     * @property bool $unsubscribe_notification
     * @property bool $send_keyword_message
     * @property bool $status
     * @property string|null $signup_sms
     * @property string|null $welcome_sms
     * @property string|null $unsubscribe_sms
     * @property string|null $cache
     * @property string|null $batch_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property int|null $sending_server
     * @property Contacts $contact
     * @method BelongsTo|_IH_Contacts_QB contact()
     * @property _IH_ContactGroupFields_C|ContactGroupFields[] $contactGroupFields
     * @property-read int $contact_group_fields_count
     * @method HasMany|_IH_ContactGroupFields_QB contactGroupFields()
     * @property User $customer
     * @method BelongsTo|_IH_User_QB customer()
     * @property _IH_ContactGroupFields_C|ContactGroupFields[] $getFields
     * @property-read int $get_fields_count
     * @method HasMany|_IH_ContactGroupFields_QB getFields()
     * @property _IH_ContactGroupFields_C|ContactGroupFields[] $getPhoneField
     * @property-read int $get_phone_field_count
     * @method HasMany|_IH_ContactGroupFields_QB getPhoneField()
     * @property _IH_JobMonitor_C|JobMonitor[] $importJobs
     * @property-read int $import_jobs_count
     * @method HasMany|_IH_JobMonitor_QB importJobs()
     * @property _IH_JobMonitor_C|JobMonitor[] $jobMonitors
     * @property-read int $job_monitors_count
     * @method HasMany|_IH_JobMonitor_QB jobMonitors()
     * @property _IH_ContactGroupsOptinKeywords_C|ContactGroupsOptinKeywords[] $optInKeywords
     * @property-read int $opt_in_keywords_count
     * @method HasMany|_IH_ContactGroupsOptinKeywords_QB optInKeywords()
     * @property _IH_ContactGroupsOptoutKeywords_C|ContactGroupsOptoutKeywords[] $optOutKeywords
     * @property-read int $opt_out_keywords_count
     * @method HasMany|_IH_ContactGroupsOptoutKeywords_QB optOutKeywords()
     * @property _IH_Segments_C|Segments[] $segments
     * @property-read int $segments_count
     * @method HasMany|_IH_Segments_QB segments()
     * @property _IH_Segments_C|Segments[] $segmentsCount
     * @property-read int $segments_count_count
     * @method HasMany|_IH_Segments_QB segmentsCount()
     * @property _IH_ContactsCustomField_C|ContactsCustomField[] $subscriberFields
     * @property-read int $subscriber_fields_count
     * @method HasManyThrough|_IH_ContactsCustomField_QB subscriberFields()
     * @property _IH_Contacts_C|Contacts[] $subscribers
     * @property-read int $subscribers_count
     * @method HasMany|_IH_Contacts_QB subscribers()
     * @method static _IH_ContactGroups_QB onWriteConnection()
     * @method _IH_ContactGroups_QB newQuery()
     * @method static _IH_ContactGroups_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_ContactGroups_QB query()
     * @method static _IH_ContactGroups_QB with(array|string $relations)
     * @method _IH_ContactGroups_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_ContactGroups_C|ContactGroups[] all($columns = ['*'])
     * @ownLinks customer_id,\App\Models\User,id
     * @foreignLinks id,\App\Models\Contacts,group_id|id,\App\Models\ContactGroupsOptinKeywords,contact_group|id,\App\Models\ContactGroupsOptoutKeywords,contact_group|id,\App\Models\CampaignsList,contact_list_id|id,\App\Models\TrackingLog,contact_group_id|id,\App\Models\Automation,contact_list_id|id,\App\Models\ContactGroupFields,contact_group_id|id,\App\Models\Segments,contact_group_id|id,\App\Models\FailedContactImport,contact_group_id
     * @mixin _IH_ContactGroups_QB
     */
    class ContactGroups extends Model {}
    
    /**
     * @property int $id
     * @property string $uid
     * @property int $contact_group
     * @property string $keyword
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property ContactGroups $ContactGroups
     * @method BelongsTo|_IH_ContactGroups_QB ContactGroups()
     * @method static _IH_ContactGroupsOptinKeywords_QB onWriteConnection()
     * @method _IH_ContactGroupsOptinKeywords_QB newQuery()
     * @method static _IH_ContactGroupsOptinKeywords_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_ContactGroupsOptinKeywords_QB query()
     * @method static _IH_ContactGroupsOptinKeywords_QB with(array|string $relations)
     * @method _IH_ContactGroupsOptinKeywords_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_ContactGroupsOptinKeywords_C|ContactGroupsOptinKeywords[] all($columns = ['*'])
     * @ownLinks contact_group,\App\Models\ContactGroups,id
     * @mixin _IH_ContactGroupsOptinKeywords_QB
     */
    class ContactGroupsOptinKeywords extends Model {}
    
    /**
     * @property int $id
     * @property string $uid
     * @property int $contact_group
     * @property string $keyword
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property ContactGroups $ContactGroups
     * @method BelongsTo|_IH_ContactGroups_QB ContactGroups()
     * @method static _IH_ContactGroupsOptoutKeywords_QB onWriteConnection()
     * @method _IH_ContactGroupsOptoutKeywords_QB newQuery()
     * @method static _IH_ContactGroupsOptoutKeywords_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_ContactGroupsOptoutKeywords_QB query()
     * @method static _IH_ContactGroupsOptoutKeywords_QB with(array|string $relations)
     * @method _IH_ContactGroupsOptoutKeywords_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_ContactGroupsOptoutKeywords_C|ContactGroupsOptoutKeywords[] all($columns = ['*'])
     * @ownLinks contact_group,\App\Models\ContactGroups,id
     * @mixin _IH_ContactGroupsOptoutKeywords_QB
     */
    class ContactGroupsOptoutKeywords extends Model {}
    
    /**
     * @property int $id
     * @property string $uid
     * @property int $customer_id
     * @property int|null $group_id
     * @property int $phone
     * @property string $status
     * @property string|null $first_name
     * @property string|null $last_name
     * @property string|null $email
     * @property string|null $username
     * @property string|null $company
     * @property string|null $address
     * @property Carbon|null $birth_date
     * @property Carbon|null $anniversary_date
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property _IH_ChatBox_C|ChatBox[] $chatBoxes
     * @property-read int $chat_boxes_count
     * @method HasMany|_IH_ChatBox_QB chatBoxes()
     * @property ContactGroups|null $contactGroup
     * @method BelongsTo|_IH_ContactGroups_QB contactGroup()
     * @property _IH_ContactGroupFields_C|ContactGroupFields[] $contactGroupFields
     * @property-read int $contact_group_fields_count
     * @method HasMany|_IH_ContactGroupFields_QB contactGroupFields()
     * @property _IH_ContactsCustomField_C|ContactsCustomField[] $contactsFields
     * @property-read int $contacts_fields_count
     * @method HasMany|_IH_ContactsCustomField_QB contactsFields()
     * @method static _IH_Contacts_QB onWriteConnection()
     * @method _IH_Contacts_QB newQuery()
     * @method static _IH_Contacts_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_Contacts_QB query()
     * @method static _IH_Contacts_QB with(array|string $relations)
     * @method _IH_Contacts_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Contacts_C|Contacts[] all($columns = ['*'])
     * @ownLinks customer_id,\App\Models\User,id|group_id,\App\Models\ContactGroups,id
     * @foreignLinks id,\App\Models\Customer,contact_id|id,\App\Models\ContactsCustomField,contact_id|id,\App\Models\TrackingLog,contact_id
     * @mixin _IH_Contacts_QB
     */
    class Contacts extends Model {}
    
    /**
     * @property int $id
     * @property int $contact_id
     * @property string|null $value
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property int $field_id
     * @property ContactGroupFields $field
     * @method BelongsTo|_IH_ContactGroupFields_QB field()
     * @method static _IH_ContactsCustomField_QB onWriteConnection()
     * @method _IH_ContactsCustomField_QB newQuery()
     * @method static _IH_ContactsCustomField_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_ContactsCustomField_QB query()
     * @method static _IH_ContactsCustomField_QB with(array|string $relations)
     * @method _IH_ContactsCustomField_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_ContactsCustomField_C|ContactsCustomField[] all($columns = ['*'])
     * @ownLinks contact_id,\App\Models\Contacts,id|field_id,\App\Models\ContactGroupFields,id
     * @mixin _IH_ContactsCustomField_QB
     */
    class ContactsCustomField extends Model {}
    
    /**
     * @property int $id
     * @property string $name
     * @property string $iso_code
     * @property string $country_code
     * @property bool $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property string $uid
     * @property _IH_PlansCoverageCountries_C|PlansCoverageCountries[] $plans_coverage_countries
     * @property-read int $plans_coverage_countries_count
     * @method HasMany|_IH_PlansCoverageCountries_QB plans_coverage_countries()
     * @method static _IH_Country_QB onWriteConnection()
     * @method _IH_Country_QB newQuery()
     * @method static _IH_Country_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_Country_QB query()
     * @method static _IH_Country_QB with(array|string $relations)
     * @method _IH_Country_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Country_C|Country[] all($columns = ['*'])
     * @foreignLinks id,\App\Models\PlansCoverageCountries,country_id|id,\App\Models\CustomerBasedPricingPlan,country_id|id,\App\Models\SendingServerBasedPricingPlans,country_id
     * @mixin _IH_Country_QB
     */
    class Country extends Model {}
    
    /**
     * @property int $id
     * @property int $user_id
     * @property string $ref_id
     * @property string|null $ref_type
     * @property string $csv_filename
     * @property bool $csv_header
     * @property string $csv_data
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_CsvData_QB onWriteConnection()
     * @method _IH_CsvData_QB newQuery()
     * @method static _IH_CsvData_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_CsvData_QB query()
     * @method static _IH_CsvData_QB with(array|string $relations)
     * @method _IH_CsvData_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_CsvData_C|CsvData[] all($columns = ['*'])
     * @ownLinks user_id,\App\Models\User,id
     * @mixin _IH_CsvData_QB
     */
    class CsvData extends Model {}
    
    /**
     * @property int $id
     * @property string $uid
     * @property int|null $user_id
     * @property string $name
     * @property string $code
     * @property string $format
     * @property bool $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Admin $admin
     * @method BelongsTo|_IH_Admin_QB admin()
     * @method static _IH_Currency_QB onWriteConnection()
     * @method _IH_Currency_QB newQuery()
     * @method static _IH_Currency_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_Currency_QB query()
     * @method static _IH_Currency_QB with(array|string $relations)
     * @method _IH_Currency_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Currency_C|Currency[] all($columns = ['*'])
     * @ownLinks user_id,\App\Models\User,id
     * @foreignLinks id,\App\Models\Plan,currency_id|id,\App\Models\Keywords,currency_id|id,\App\Models\Senderid,currency_id|id,\App\Models\PhoneNumbers,currency_id|id,\App\Models\SenderidPlan,currency_id|id,\App\Models\Invoices,currency_id
     * @mixin _IH_Currency_QB
     */
    class Currency extends Model {}
    
    /**
     * @property int $id
     * @property string $uid
     * @property int $server_id
     * @property string $http_request_method
     * @property bool $json_encoded_post
     * @property string|null $content_type
     * @property string|null $content_type_accept
     * @property string|null $character_encoding
     * @property bool $ssl_certificate_verification
     * @property string|null $authorization
     * @property string|null $multi_sms_delimiter
     * @property string $username_param
     * @property string $username_value
     * @property string|null $password_param
     * @property string|null $password_value
     * @property bool $password_status
     * @property string|null $action_param
     * @property string|null $action_value
     * @property bool $action_status
     * @property string|null $source_param
     * @property string|null $source_value
     * @property bool $source_status
     * @property string $destination_param
     * @property string $message_param
     * @property string|null $unicode_param
     * @property string|null $unicode_value
     * @property bool $unicode_status
     * @property string|null $route_param
     * @property string|null $route_value
     * @property bool $route_status
     * @property string|null $language_param
     * @property string|null $language_value
     * @property bool $language_status
     * @property string|null $custom_one_param
     * @property string|null $custom_one_value
     * @property bool $custom_one_status
     * @property string|null $custom_two_param
     * @property string|null $custom_two_value
     * @property bool $custom_two_status
     * @property string|null $custom_three_param
     * @property string|null $custom_three_value
     * @property bool $custom_three_status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property SendingServer $sending_server
     * @method BelongsTo|_IH_SendingServer_QB sending_server()
     * @method static _IH_CustomSendingServer_QB onWriteConnection()
     * @method _IH_CustomSendingServer_QB newQuery()
     * @method static _IH_CustomSendingServer_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_CustomSendingServer_QB query()
     * @method static _IH_CustomSendingServer_QB with(array|string $relations)
     * @method _IH_CustomSendingServer_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_CustomSendingServer_C|CustomSendingServer[] all($columns = ['*'])
     * @ownLinks server_id,\App\Models\SendingServer,id
     * @mixin _IH_CustomSendingServer_QB
     */
    class CustomSendingServer extends Model {}
    
    /**
     * @property int $id
     * @property string $uid
     * @property int $user_id
     * @property int|null $contact_id
     * @property string|null $company
     * @property string|null $website
     * @property string|null $address
     * @property string|null $city
     * @property string|null $postcode
     * @property string|null $financial_address
     * @property string|null $financial_city
     * @property string|null $financial_postcode
     * @property string|null $tax_number
     * @property string|null $state
     * @property string|null $country
     * @property string|null $phone
     * @property string|null $notifications
     * @property string|null $permissions
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property _IH_Blacklists_C|Blacklists[] $blacklistCounts
     * @property-read int $blacklist_counts_count
     * @method HasMany|_IH_Blacklists_QB blacklistCounts()
     * @property Contacts|null $contact
     * @method BelongsTo|_IH_Contacts_QB contact()
     * @property _IH_ContactGroups_C|ContactGroups[] $lists
     * @property-read int $lists_count
     * @method HasMany|_IH_ContactGroups_QB lists()
     * @property _IH_ContactGroups_C|ContactGroups[] $listsCount
     * @property-read int $lists_count_count
     * @method HasMany|_IH_ContactGroups_QB listsCount()
     * @property-read int $notifications_count
     * @method MorphToMany|_IH_DatabaseNotification_QB notifications()
     * @property DatabaseNotificationCollection|DatabaseNotification[] $readNotifications
     * @property-read int $read_notifications_count
     * @method MorphToMany|_IH_DatabaseNotification_QB readNotifications()
     * @property _IH_Templates_C|Templates[] $smsTemplateCounts
     * @property-read int $sms_template_counts_count
     * @method HasMany|_IH_Templates_QB smsTemplateCounts()
     * @property _IH_Contacts_C|Contacts[] $subscriberCounts
     * @property-read int $subscriber_counts_count
     * @method HasMany|_IH_Contacts_QB subscriberCounts()
     * @property Subscription $subscription
     * @method HasOne|_IH_Subscription_QB subscription()
     * @property DatabaseNotificationCollection|DatabaseNotification[] $unreadNotifications
     * @property-read int $unread_notifications_count
     * @method MorphToMany|_IH_DatabaseNotification_QB unreadNotifications()
     * @property User $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_Customer_QB onWriteConnection()
     * @method _IH_Customer_QB newQuery()
     * @method static _IH_Customer_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_Customer_QB query()
     * @method static _IH_Customer_QB with(array|string $relations)
     * @method _IH_Customer_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Customer_C|Customer[] all($columns = ['*'])
     * @ownLinks user_id,\App\Models\User,id|contact_id,\App\Models\Contacts,id
     * @mixin _IH_Customer_QB
     */
    class Customer extends Model {}
    
    /**
     * @property int $id
     * @property string $uid
     * @property int $user_id
     * @property int $country_id
     * @property int $plan_id
     * @property int|null $sending_server
     * @property bool $status
     * @property string|null $options
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property int|null $voice_sending_server
     * @property int|null $mms_sending_server
     * @property int|null $whatsapp_sending_server
     * @property int|null $viber_sending_server
     * @property int|null $otp_sending_server
     * @property Country $country
     * @method BelongsTo|_IH_Country_QB country()
     * @property SendingServer|null $mmsSendingServer
     * @method BelongsTo|_IH_SendingServer_QB mmsSendingServer()
     * @property SendingServer|null $otpSendingServer
     * @method BelongsTo|_IH_SendingServer_QB otpSendingServer()
     * @property Plan $plan
     * @method BelongsTo|_IH_Plan_QB plan()
     * @property SendingServer|null $sendingServer
     * @method BelongsTo|_IH_SendingServer_QB sendingServer()
     * @property User $user
     * @method BelongsTo|_IH_User_QB user()
     * @property SendingServer|null $viberSendingServer
     * @method BelongsTo|_IH_SendingServer_QB viberSendingServer()
     * @property SendingServer|null $voiceSendingServer
     * @method BelongsTo|_IH_SendingServer_QB voiceSendingServer()
     * @property SendingServer|null $whatsappSendingServer
     * @method BelongsTo|_IH_SendingServer_QB whatsappSendingServer()
     * @method static _IH_CustomerBasedPricingPlan_QB onWriteConnection()
     * @method _IH_CustomerBasedPricingPlan_QB newQuery()
     * @method static _IH_CustomerBasedPricingPlan_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_CustomerBasedPricingPlan_QB query()
     * @method static _IH_CustomerBasedPricingPlan_QB with(array|string $relations)
     * @method _IH_CustomerBasedPricingPlan_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_CustomerBasedPricingPlan_C|CustomerBasedPricingPlan[] all($columns = ['*'])
     * @ownLinks user_id,\App\Models\User,id|country_id,\App\Models\Country,id|plan_id,\App\Models\Plan,id|sending_server,\App\Models\SendingServer,id
     * @mixin _IH_CustomerBasedPricingPlan_QB
     */
    class CustomerBasedPricingPlan extends Model {}
    
    /**
     * @property int $id
     * @property string $uid
     * @property int $user_id
     * @property int $sending_server
     * @property bool $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property SendingServer $sendingServer
     * @method BelongsTo|_IH_SendingServer_QB sendingServer()
     * @property User $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_CustomerBasedSendingServer_QB onWriteConnection()
     * @method _IH_CustomerBasedSendingServer_QB newQuery()
     * @method static _IH_CustomerBasedSendingServer_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_CustomerBasedSendingServer_QB query()
     * @method static _IH_CustomerBasedSendingServer_QB with(array|string $relations)
     * @method _IH_CustomerBasedSendingServer_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_CustomerBasedSendingServer_C|CustomerBasedSendingServer[] all($columns = ['*'])
     * @ownLinks user_id,\App\Models\User,id|sending_server,\App\Models\SendingServer,id
     * @mixin _IH_CustomerBasedSendingServer_QB
     */
    class CustomerBasedSendingServer extends Model {}
    
    /**
     * @property int $id
     * @property string $uid
     * @property string $name
     * @property string $slug
     * @property string $subject
     * @property string|null $content
     * @property bool $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_EmailTemplates_QB onWriteConnection()
     * @method _IH_EmailTemplates_QB newQuery()
     * @method static _IH_EmailTemplates_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_EmailTemplates_QB query()
     * @method static _IH_EmailTemplates_QB with(array|string $relations)
     * @method _IH_EmailTemplates_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_EmailTemplates_C|EmailTemplates[] all($columns = ['*'])
     * @mixin _IH_EmailTemplates_QB
     */
    class EmailTemplates extends Model {}
    
    /**
     * @property int $id
     * @property int $user_id
     * @property int $contact_group_id
     * @property array $record_data
     * @property string $reason
     * @property string|null $job_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property ContactGroups $contactGroup
     * @method BelongsTo|_IH_ContactGroups_QB contactGroup()
     * @property User $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_FailedContactImport_QB onWriteConnection()
     * @method _IH_FailedContactImport_QB newQuery()
     * @method static _IH_FailedContactImport_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_FailedContactImport_QB query()
     * @method static _IH_FailedContactImport_QB with(array|string $relations)
     * @method _IH_FailedContactImport_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_FailedContactImport_C|FailedContactImport[] all($columns = ['*'])
     * @ownLinks user_id,\App\Models\User,id|contact_group_id,\App\Models\ContactGroups,id|job_id,\App\Models\Job,id
     * @mixin _IH_FailedContactImport_QB
     */
    class FailedContactImport extends Model {}
    
    /**
     * @property int $id
     * @property int $user_id
     * @property int $sending_server_id
     * @property int $campaign_id
     * @property string|null $phone
     * @property string|null $sender_id
     * @property string|null $sms_type
     * @property int|null $sms_count
     * @property string|null $cost
     * @property string|null $message
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Campaigns $campaign
     * @method BelongsTo|_IH_Campaigns_QB campaign()
     * @property SendingServer $sendingServer
     * @method BelongsTo|_IH_SendingServer_QB sendingServer()
     * @property User $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_FileCampaignData_QB onWriteConnection()
     * @method _IH_FileCampaignData_QB newQuery()
     * @method static _IH_FileCampaignData_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_FileCampaignData_QB query()
     * @method static _IH_FileCampaignData_QB with(array|string $relations)
     * @method _IH_FileCampaignData_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_FileCampaignData_C|FileCampaignData[] all($columns = ['*'])
     * @ownLinks user_id,\App\Models\User,id|sending_server_id,\App\Models\SendingServer,id|campaign_id,\App\Models\Campaigns,id
     * @mixin _IH_FileCampaignData_QB
     */
    class FileCampaignData extends Model {}
    
    /**
     * @property int $id
     * @property string $uid
     * @property int $user_id
     * @property int $currency_id
     * @property int $payment_method
     * @property string $amount
     * @property string $type
     * @property string|null $description
     * @property string|null $transaction_id
     * @property string|null $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property string|null $tax
     * @property string|null $total_amount
     * @property Currency $currency
     * @method BelongsTo|_IH_Currency_QB currency()
     * @property PaymentMethods $paymentMethod
     * @method BelongsTo|_IH_PaymentMethods_QB paymentMethod()
     * @property User $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_Invoices_QB onWriteConnection()
     * @method _IH_Invoices_QB newQuery()
     * @method static _IH_Invoices_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_Invoices_QB query()
     * @method static _IH_Invoices_QB with(array|string $relations)
     * @method _IH_Invoices_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Invoices_C|Invoices[] all($columns = ['*'])
     * @ownLinks user_id,\App\Models\User,id|currency_id,\App\Models\Currency,id|payment_method,\App\Models\PaymentMethods,id
     * @mixin _IH_Invoices_QB
     */
    class Invoices extends Model {}
    
    /**
     * @property int $id
     * @property string $queue
     * @property string $payload
     * @property int $attempts
     * @property int|null $reserved_at
     * @property int $available_at
     * @property int $created_at
     * @method static _IH_Job_QB onWriteConnection()
     * @method _IH_Job_QB newQuery()
     * @method static _IH_Job_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_Job_QB query()
     * @method static _IH_Job_QB with(array|string $relations)
     * @method _IH_Job_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Job_C|Job[] all($columns = ['*'])
     * @foreignLinks id,\App\Models\JobMonitor,job_id|id,\App\Models\FailedContactImport,job_id
     * @mixin _IH_Job_QB
     */
    class Job extends Model {}
    
    /**
     * @property int $id
     * @property string $uid
     * @property string $subject_name
     * @property int $subject_id
     * @property string|null $batch_id
     * @property int|null $job_id
     * @property string|null $job_type
     * @property string|null $error
     * @property string|null $data
     * @property string|null $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Job|null $job
     * @method BelongsTo|_IH_Job_QB job()
     * @method static _IH_JobMonitor_QB onWriteConnection()
     * @method _IH_JobMonitor_QB newQuery()
     * @method static _IH_JobMonitor_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_JobMonitor_QB query()
     * @method static _IH_JobMonitor_QB with(array|string $relations)
     * @method _IH_JobMonitor_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_JobMonitor_C|JobMonitor[] all($columns = ['*'])
     * @ownLinks job_id,\App\Models\Job,id
     * @mixin _IH_JobMonitor_QB
     * @method static JobMonitorFactory factory(callable|int|mixed[]|null $count = null, callable|mixed[] $state = [])
     */
    class JobMonitor extends Model {}
    
    /**
     * @property int $id
     * @property string $uid
     * @property int|null $user_id
     * @property int|null $currency_id
     * @property string $title
     * @property string $keyword_name
     * @property string|null $sender_id
     * @property string|null $reply_text
     * @property string|null $reply_voice
     * @property string|null $reply_mms
     * @property string $status
     * @property string $price
     * @property string|null $billing_cycle
     * @property int|null $frequency_amount
     * @property string|null $frequency_unit
     * @property Carbon $validity_date
     * @property string|null $transaction_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Currency|null $currency
     * @method BelongsTo|_IH_Currency_QB currency()
     * @property User|null $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_Keywords_QB onWriteConnection()
     * @method _IH_Keywords_QB newQuery()
     * @method static _IH_Keywords_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_Keywords_QB query()
     * @method static _IH_Keywords_QB with(array|string $relations)
     * @method _IH_Keywords_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Keywords_C|Keywords[] all($columns = ['*'])
     * @ownLinks user_id,\App\Models\User,id|currency_id,\App\Models\Currency,id
     * @mixin _IH_Keywords_QB
     */
    class Keywords extends Model {}
    
    /**
     * @property int $id
     * @property string $name
     * @property string $code
     * @property string $iso_code
     * @property bool $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_Language_QB onWriteConnection()
     * @method _IH_Language_QB newQuery()
     * @method static _IH_Language_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_Language_QB query()
     * @method static _IH_Language_QB with(array|string $relations)
     * @method _IH_Language_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Language_C|Language[] all($columns = ['*'])
     * @mixin _IH_Language_QB
     */
    class Language extends Model {}
    
    /**
     * @property int $id
     * @property string $uid
     * @property int $user_id
     * @property string $notification_for
     * @property string|null $notification_type
     * @property string|null $message
     * @property bool $mark_read
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property User $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_Notifications_QB onWriteConnection()
     * @method _IH_Notifications_QB newQuery()
     * @method static _IH_Notifications_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_Notifications_QB query()
     * @method static _IH_Notifications_QB with(array|string $relations)
     * @method _IH_Notifications_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Notifications_C|Notifications[] all($columns = ['*'])
     * @ownLinks user_id,\App\Models\User,id
     * @mixin _IH_Notifications_QB
     */
    class Notifications extends Model {}
    
    /**
     * @property int $id
     * @property string $uid
     * @property string $name
     * @property string $type
     * @property string|null $options
     * @property bool $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property bool $is_default
     * @method static _IH_PaymentMethods_QB onWriteConnection()
     * @method _IH_PaymentMethods_QB newQuery()
     * @method static _IH_PaymentMethods_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_PaymentMethods_QB query()
     * @method static _IH_PaymentMethods_QB with(array|string $relations)
     * @method _IH_PaymentMethods_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_PaymentMethods_C|PaymentMethods[] all($columns = ['*'])
     * @foreignLinks id,\App\Models\Subscription,payment_method_id|id,\App\Models\Invoices,payment_method
     * @mixin _IH_PaymentMethods_QB
     */
    class PaymentMethods extends Model {}
    
    /**
     * @property int $id
     * @property string $uid
     * @property int $role_id
     * @property string $name
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_Permission_QB onWriteConnection()
     * @method _IH_Permission_QB newQuery()
     * @method static _IH_Permission_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_Permission_QB query()
     * @method static _IH_Permission_QB with(array|string $relations)
     * @method _IH_Permission_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Permission_C|Permission[] all($columns = ['*'])
     * @ownLinks role_id,\App\Models\Role,id
     * @mixin _IH_Permission_QB
     */
    class Permission extends Model {}
    
    /**
     * @property int $id
     * @property string $uid
     * @property int|null $user_id
     * @property int|null $currency_id
     * @property string $number
     * @property string $status
     * @property mixed|null $capabilities
     * @property string $price
     * @property string $billing_cycle
     * @property int $frequency_amount
     * @property string $frequency_unit
     * @property Carbon $validity_date
     * @property string|null $transaction_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Currency|null $currency
     * @method BelongsTo|_IH_Currency_QB currency()
     * @property User|null $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_PhoneNumbers_QB onWriteConnection()
     * @method _IH_PhoneNumbers_QB newQuery()
     * @method static _IH_PhoneNumbers_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_PhoneNumbers_QB query()
     * @method static _IH_PhoneNumbers_QB with(array|string $relations)
     * @method _IH_PhoneNumbers_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_PhoneNumbers_C|PhoneNumbers[] all($columns = ['*'])
     * @ownLinks user_id,\App\Models\User,id|currency_id,\App\Models\Currency,id
     * @mixin _IH_PhoneNumbers_QB
     */
    class PhoneNumbers extends Model {}
    
    /**
     * @property int $id
     * @property string $uid
     * @property int|null $user_id
     * @property int $currency_id
     * @property string $name
     * @property string|null $description
     * @property float $price
     * @property string $billing_cycle
     * @property int $frequency_amount
     * @property string $frequency_unit
     * @property string $options
     * @property bool $status
     * @property int $custom_order
     * @property bool $is_default
     * @property bool $is_popular
     * @property bool $tax_billing_required
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property bool $show_in_customer
     * @property bool $is_dlt
     * @property _IH_PlanSendingCreditPrice_C|PlanSendingCreditPrice[] $PlanCreditPrice
     * @property-read int $plan_credit_price_count
     * @method HasMany|_IH_PlanSendingCreditPrice_QB PlanCreditPrice()
     * @property Currency $currency
     * @method BelongsTo|_IH_Currency_QB currency()
     * @property _IH_Subscription_C|Subscription[] $customersCount
     * @property-read int $customers_count_count
     * @method HasMany|_IH_Subscription_QB customersCount()
     * @property _IH_PlansCoverageCountries_C|PlansCoverageCountries[] $plansCoverageCountries
     * @property-read int $plans_coverage_countries_count
     * @method HasMany|_IH_PlansCoverageCountries_QB plansCoverageCountries()
     * @property _IH_Subscription_C|Subscription[] $subscriptions
     * @property-read int $subscriptions_count
     * @method HasMany|_IH_Subscription_QB subscriptions()
     * @property User|null $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_Plan_QB onWriteConnection()
     * @method _IH_Plan_QB newQuery()
     * @method static _IH_Plan_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_Plan_QB query()
     * @method static _IH_Plan_QB with(array|string $relations)
     * @method _IH_Plan_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Plan_C|Plan[] all($columns = ['*'])
     * @ownLinks user_id,\App\Models\User,id|currency_id,\App\Models\Currency,id
     * @foreignLinks id,\App\Models\Subscription,plan_id|id,\App\Models\PlansCoverageCountries,plan_id|id,\App\Models\CustomerBasedPricingPlan,plan_id|id,\App\Models\PlanSendingCreditPrice,plan_id
     * @mixin _IH_Plan_QB
     */
    class Plan extends Model {}
    
    /**
     * @property int $id
     * @property string $uid
     * @property int $plan_id
     * @property int $unit_from
     * @property int $unit_to
     * @property string $per_credit_cost
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Plan $plan
     * @method BelongsTo|_IH_Plan_QB plan()
     * @method static _IH_PlanSendingCreditPrice_QB onWriteConnection()
     * @method _IH_PlanSendingCreditPrice_QB newQuery()
     * @method static _IH_PlanSendingCreditPrice_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_PlanSendingCreditPrice_QB query()
     * @method static _IH_PlanSendingCreditPrice_QB with(array|string $relations)
     * @method _IH_PlanSendingCreditPrice_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_PlanSendingCreditPrice_C|PlanSendingCreditPrice[] all($columns = ['*'])
     * @ownLinks plan_id,\App\Models\Plan,id
     * @mixin _IH_PlanSendingCreditPrice_QB
     */
    class PlanSendingCreditPrice extends Model {}
    
    /**
     * @property int $id
     * @property int $country_id
     * @property int $plan_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property string $uid
     * @property bool $status
     * @property string|null $options
     * @property int|null $sending_server
     * @property int|null $voice_sending_server
     * @property int|null $mms_sending_server
     * @property int|null $whatsapp_sending_server
     * @property int|null $viber_sending_server
     * @property int|null $otp_sending_server
     * @property Country $country
     * @method BelongsTo|_IH_Country_QB country()
     * @property SendingServer|null $mmsSendingServer
     * @method BelongsTo|_IH_SendingServer_QB mmsSendingServer()
     * @property SendingServer|null $otpSendingServer
     * @method BelongsTo|_IH_SendingServer_QB otpSendingServer()
     * @property Plan $plan
     * @method BelongsTo|_IH_Plan_QB plan()
     * @property SendingServer|null $sendingServer
     * @method BelongsTo|_IH_SendingServer_QB sendingServer()
     * @property SendingServer|null $viberSendingServer
     * @method BelongsTo|_IH_SendingServer_QB viberSendingServer()
     * @property SendingServer|null $voiceSendingServer
     * @method BelongsTo|_IH_SendingServer_QB voiceSendingServer()
     * @property SendingServer|null $whatsappSendingServer
     * @method BelongsTo|_IH_SendingServer_QB whatsappSendingServer()
     * @method static _IH_PlansCoverageCountries_QB onWriteConnection()
     * @method _IH_PlansCoverageCountries_QB newQuery()
     * @method static _IH_PlansCoverageCountries_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_PlansCoverageCountries_QB query()
     * @method static _IH_PlansCoverageCountries_QB with(array|string $relations)
     * @method _IH_PlansCoverageCountries_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_PlansCoverageCountries_C|PlansCoverageCountries[] all($columns = ['*'])
     * @ownLinks country_id,\App\Models\Country,id|plan_id,\App\Models\Plan,id|sending_server,\App\Models\SendingServer,id
     * @mixin _IH_PlansCoverageCountries_QB
     */
    class PlansCoverageCountries extends Model {}
    
    /**
     * @property int $id
     * @property string $uid
     * @property string $name
     * @property string $type
     * @property string $title
     * @property string $description
     * @property string $version
     * @property string $status
     * @property string|null $data
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property string|null $purchase_code
     * @method static _IH_Plugins_QB onWriteConnection()
     * @method _IH_Plugins_QB newQuery()
     * @method static _IH_Plugins_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_Plugins_QB query()
     * @method static _IH_Plugins_QB with(array|string $relations)
     * @method _IH_Plugins_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Plugins_C|Plugins[] all($columns = ['*'])
     * @mixin _IH_Plugins_QB
     */
    class Plugins extends Model {}
    
    /**
     * @property int $id
     * @property string $uid
     * @property int $user_id
     * @property int|null $campaign_id
     * @property string|null $from
     * @property string $to
     * @property string|null $message
     * @property string|null $media_url
     * @property string $sms_type
     * @property string $status
     * @property string|null $send_by
     * @property string $cost
     * @property string|null $api_key
     * @property int|null $sending_server_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property int|null $automation_id
     * @property int|null $sms_count
     * @property string|null $customer_status
     * @property string|null $direction
     * @property Stringable $escaped_from attribute
     * @property Stringable $escaped_message attribute
     * @property _IH_Campaigns_C|Campaigns[] $campaign
     * @property-read int $campaign_count
     * @method HasMany|_IH_Campaigns_QB campaign()
     * @property SendingServer|null $sendingServer
     * @method BelongsTo|_IH_SendingServer_QB sendingServer()
     * @property User $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_Reports_QB onWriteConnection()
     * @method _IH_Reports_QB newQuery()
     * @method static _IH_Reports_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_Reports_QB query()
     * @method static _IH_Reports_QB with(array|string $relations)
     * @method _IH_Reports_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Reports_C|Reports[] all($columns = ['*'])
     * @ownLinks user_id,\App\Models\User,id|campaign_id,\App\Models\Campaigns,id|sending_server_id,\App\Models\SendingServer,id|automation_id,\App\Models\Automation,id
     * @mixin _IH_Reports_QB
     */
    class Reports extends Model {}
    
    /**
     * @property int $id
     * @property string $uid
     * @property string $name
     * @property bool $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property-read bool $can_delete attribute
     * @property-read bool $can_edit attribute
     * @property-read $permissions attribute
     * @property _IH_RoleUser_C|RoleUser[] $admins
     * @property-read int $admins_count
     * @method HasMany|_IH_RoleUser_QB admins()
     * @property _IH_Permission_C|Permission[] $getPermissionsAttribute
     * @property-read int $get_permissions_attribute_count
     * @method HasMany|_IH_Permission_QB getPermissionsAttribute()
     * @property-read int $permissions_count
     * @method HasMany|_IH_Permission_QB permissions()
     * @method static _IH_Role_QB onWriteConnection()
     * @method _IH_Role_QB newQuery()
     * @method static _IH_Role_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_Role_QB query()
     * @method static _IH_Role_QB with(array|string $relations)
     * @method _IH_Role_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Role_C|Role[] all($columns = ['*'])
     * @foreignLinks id,\App\Models\RoleUser,role_id|id,\App\Models\Permission,role_id
     * @mixin _IH_Role_QB
     */
    class Role extends Model {}
    
    /**
     * @property int $user_id
     * @property int $role_id
     * @method static _IH_RoleUser_QB onWriteConnection()
     * @method _IH_RoleUser_QB newQuery()
     * @method static _IH_RoleUser_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_RoleUser_QB query()
     * @method static _IH_RoleUser_QB with(array|string $relations)
     * @method _IH_RoleUser_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_RoleUser_C|RoleUser[] all($columns = ['*'])
     * @ownLinks user_id,\App\Models\User,id|role_id,\App\Models\Role,id
     * @mixin _IH_RoleUser_QB
     */
    class RoleUser extends Model {}
    
    /**
     * @property int $id
     * @property string $uid
     * @property int $user_id
     * @property string|null $from
     * @property string $to
     * @property string|null $message
     * @property string|null $media_url
     * @property string $sms_type
     * @property string|null $send_by
     * @property string $cost
     * @property string|null $api_key
     * @property string|null $language
     * @property string|null $gender
     * @property string|null $status
     * @property int|null $sending_server
     * @property Carbon|null $schedule_on
     * @property string|null $dlt_template_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property int|null $sms_count
     * @property string|null $direction
     * @property SendingServer $sendingServer
     * @method BelongsTo|_IH_SendingServer_QB sendingServer()
     * @property User $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_ScheduleMessage_QB onWriteConnection()
     * @method _IH_ScheduleMessage_QB newQuery()
     * @method static _IH_ScheduleMessage_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_ScheduleMessage_QB query()
     * @method static _IH_ScheduleMessage_QB with(array|string $relations)
     * @method _IH_ScheduleMessage_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_ScheduleMessage_C|ScheduleMessage[] all($columns = ['*'])
     * @ownLinks user_id,\App\Models\User,id|sending_server,\App\Models\SendingServer,id
     * @mixin _IH_ScheduleMessage_QB
     */
    class ScheduleMessage extends Model {}
    
    /**
     * @property int $id
     * @property string $uid
     * @property int $segment_id
     * @property int|null $field_id
     * @property string $operator
     * @property string|null $value
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property ContactGroupFields|null $field
     * @method BelongsTo|_IH_ContactGroupFields_QB field()
     * @method static _IH_SegmentConditions_QB onWriteConnection()
     * @method _IH_SegmentConditions_QB newQuery()
     * @method static _IH_SegmentConditions_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_SegmentConditions_QB query()
     * @method static _IH_SegmentConditions_QB with(array|string $relations)
     * @method _IH_SegmentConditions_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_SegmentConditions_C|SegmentConditions[] all($columns = ['*'])
     * @ownLinks segment_id,\App\Models\Segments,id|field_id,\App\Models\ContactGroupFields,id
     * @mixin _IH_SegmentConditions_QB
     */
    class SegmentConditions extends Model {}
    
    /**
     * @property int $id
     * @property string $uid
     * @property int $contact_group_id
     * @property string $name
     * @property string $matching
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property ContactGroups $contactGroup
     * @method BelongsTo|_IH_ContactGroups_QB contactGroup()
     * @property _IH_SegmentConditions_C|SegmentConditions[] $segmentConditions
     * @property-read int $segment_conditions_count
     * @method HasMany|_IH_SegmentConditions_QB segmentConditions()
     * @method static _IH_Segments_QB onWriteConnection()
     * @method _IH_Segments_QB newQuery()
     * @method static _IH_Segments_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_Segments_QB query()
     * @method static _IH_Segments_QB with(array|string $relations)
     * @method _IH_Segments_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Segments_C|Segments[] all($columns = ['*'])
     * @ownLinks contact_group_id,\App\Models\ContactGroups,id
     * @foreignLinks id,\App\Models\SegmentConditions,segment_id
     * @mixin _IH_Segments_QB
     */
    class Segments extends Model {}
    
    /**
     * @method static _IH_SendCampaignSMS_QB onWriteConnection()
     * @method _IH_SendCampaignSMS_QB newQuery()
     * @method static _IH_SendCampaignSMS_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_SendCampaignSMS_QB query()
     * @method static _IH_SendCampaignSMS_QB with(array|string $relations)
     * @method _IH_SendCampaignSMS_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_SendCampaignSMS_C|SendCampaignSMS[] all($columns = ['*'])
     * @mixin _IH_SendCampaignSMS_QB
     */
    class SendCampaignSMS extends Model {}
    
    /**
     * @property int $id
     * @property string $uid
     * @property int|null $user_id
     * @property int|null $currency_id
     * @property string $sender_id
     * @property string $status
     * @property string $price
     * @property string $billing_cycle
     * @property int $frequency_amount
     * @property string $frequency_unit
     * @property Carbon $validity_date
     * @property string|null $transaction_id
     * @property bool $payment_claimed
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property string|null $description
     * @property string|null $entity_id
     * @property string|null $document
     * @property Currency|null $currency
     * @method BelongsTo|_IH_Currency_QB currency()
     * @property User|null $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_Senderid_QB onWriteConnection()
     * @method _IH_Senderid_QB newQuery()
     * @method static _IH_Senderid_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_Senderid_QB query()
     * @method static _IH_Senderid_QB with(array|string $relations)
     * @method _IH_Senderid_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Senderid_C|Senderid[] all($columns = ['*'])
     * @ownLinks user_id,\App\Models\User,id|currency_id,\App\Models\Currency,id
     * @mixin _IH_Senderid_QB
     */
    class Senderid extends Model {}
    
    /**
     * @property int $id
     * @property string $uid
     * @property int|null $currency_id
     * @property float $price
     * @property string $billing_cycle
     * @property int $frequency_amount
     * @property string $frequency_unit
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Currency|null $currency
     * @method BelongsTo|_IH_Currency_QB currency()
     * @method static _IH_SenderidPlan_QB onWriteConnection()
     * @method _IH_SenderidPlan_QB newQuery()
     * @method static _IH_SenderidPlan_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_SenderidPlan_QB query()
     * @method static _IH_SenderidPlan_QB with(array|string $relations)
     * @method _IH_SenderidPlan_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_SenderidPlan_C|SenderidPlan[] all($columns = ['*'])
     * @ownLinks currency_id,\App\Models\Currency,id
     * @mixin _IH_SenderidPlan_QB
     */
    class SenderidPlan extends Model {}
    
    /**
     * @property int $id
     * @property string $uid
     * @property int|null $user_id
     * @property string $name
     * @property string $settings
     * @property string|null $api_link
     * @property int|null $port
     * @property string|null $username
     * @property string|null $password
     * @property string|null $route
     * @property string|null $sms_type
     * @property string|null $account_sid
     * @property string|null $auth_id
     * @property string|null $auth_token
     * @property string|null $access_key
     * @property string|null $secret_access
     * @property string|null $access_token
     * @property string|null $api_key
     * @property string|null $api_secret
     * @property string|null $user_token
     * @property string|null $project_id
     * @property string|null $api_token
     * @property string|null $auth_key
     * @property string|null $device_id
     * @property string|null $region
     * @property string|null $application_id
     * @property string $source_addr_ton
     * @property string $source_addr_npi
     * @property string $dest_addr_ton
     * @property string $dest_addr_npi
     * @property string|null $c1
     * @property string|null $c2
     * @property string|null $c3
     * @property string|null $c4
     * @property string|null $c5
     * @property string|null $c6
     * @property string|null $c7
     * @property string $type
     * @property bool $status
     * @property bool $plain
     * @property bool $schedule
     * @property bool $two_way
     * @property bool $voice
     * @property bool $mms
     * @property bool $whatsapp
     * @property int $sms_per_request
     * @property int $quota_value
     * @property int $quota_base
     * @property string $quota_unit
     * @property bool $custom
     * @property int $custom_order
     * @property string|null $success_keyword
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property bool $viber
     * @property bool $otp
     * @property string|null $voice_api_link
     * @property string|null $mms_api_link
     * @property string|null $whatsapp_api_link
     * @property string|null $viber_api_link
     * @property string|null $otp_api_link
     * @property string|null $auth_link
     * @property string $gateway_balance
     * @property Admin $admin
     * @method BelongsTo|_IH_Admin_QB admin()
     * @property CustomSendingServer $customSendingServer
     * @method BelongsTo|_IH_CustomSendingServer_QB customSendingServer()
     * @property Customer $customer
     * @method BelongsTo|_IH_Customer_QB customer()
     * @property _IH_Plan_C|Plan[] $plans
     * @property-read int $plans_count
     * @method BelongsToMany|_IH_Plan_QB plans()
     * @method static _IH_SendingServer_QB onWriteConnection()
     * @method _IH_SendingServer_QB newQuery()
     * @method static _IH_SendingServer_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_SendingServer_QB query()
     * @method static _IH_SendingServer_QB with(array|string $relations)
     * @method _IH_SendingServer_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_SendingServer_C|SendingServer[] all($columns = ['*'])
     * @ownLinks user_id,\App\Models\User,id
     * @foreignLinks id,\App\Models\CustomSendingServer,server_id|id,\App\Models\Reports,sending_server_id|id,\App\Models\ChatBoxMessage,sending_server_id|id,\App\Models\ChatBox,sending_server_id|id,\App\Models\User,api_sending_server|id,\App\Models\TrackingLog,sending_server_id|id,\App\Models\ScheduleMessage,sending_server|id,\App\Models\Automation,sending_server_id|id,\App\Models\PlansCoverageCountries,sending_server|id,\App\Models\CustomerBasedPricingPlan,sending_server|id,\App\Models\CustomerBasedSendingServer,sending_server|id,\App\Models\Campaigns,sending_server_id|id,\App\Models\Automation,sending_server_id|id,\App\Models\FileCampaignData,sending_server_id|id,\App\Models\User,api_voice_sending_server|id,\App\Models\User,api_mms_sending_server|id,\App\Models\User,api_viber_sending_server|id,\App\Models\User,api_whatsapp_sending_server|id,\App\Models\User,api_otp_sending_server
     * @mixin _IH_SendingServer_QB
     */
    class SendingServer extends Model {}
    
    /**
     * @property int $id
     * @property string $uid
     * @property int $country_id
     * @property int|null $sending_server
     * @property bool $status
     * @property string|null $options
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Country $country
     * @method BelongsTo|_IH_Country_QB country()
     * @property SendingServer|null $sendingServer
     * @method BelongsTo|_IH_SendingServer_QB sendingServer()
     * @method static _IH_SendingServerBasedPricingPlans_QB onWriteConnection()
     * @method _IH_SendingServerBasedPricingPlans_QB newQuery()
     * @method static _IH_SendingServerBasedPricingPlans_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_SendingServerBasedPricingPlans_QB query()
     * @method static _IH_SendingServerBasedPricingPlans_QB with(array|string $relations)
     * @method _IH_SendingServerBasedPricingPlans_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_SendingServerBasedPricingPlans_C|SendingServerBasedPricingPlans[] all($columns = ['*'])
     * @ownLinks country_id,\App\Models\Country,id
     * @mixin _IH_SendingServerBasedPricingPlans_QB
     */
    class SendingServerBasedPricingPlans extends Model {}
    
    /**
     * @property int $id
     * @property string $uid
     * @property string $word
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_SpamWord_QB onWriteConnection()
     * @method _IH_SpamWord_QB newQuery()
     * @method static _IH_SpamWord_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_SpamWord_QB query()
     * @method static _IH_SpamWord_QB with(array|string $relations)
     * @method _IH_SpamWord_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_SpamWord_C|SpamWord[] all($columns = ['*'])
     * @mixin _IH_SpamWord_QB
     */
    class SpamWord extends Model {}
    
    /**
     * @property int $id
     * @property string $uid
     * @property int $user_id
     * @property int $plan_id
     * @property int|null $payment_method_id
     * @property string|null $options
     * @property string $status
     * @property bool $paid
     * @property bool $payment_claimed
     * @property Carbon $current_period_ends_at
     * @property Carbon|null $start_at
     * @property Carbon|null $end_at
     * @property int|null $end_by
     * @property int $end_period_last_days
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property _IH_SubscriptionLog_C|SubscriptionLog[] $getLogs
     * @property-read int $get_logs_count
     * @method HasMany|_IH_SubscriptionLog_QB getLogs()
     * @property _IH_SubscriptionTransaction_C|SubscriptionTransaction[] $getTransactions
     * @property-read int $get_transactions_count
     * @method HasMany|_IH_SubscriptionTransaction_QB getTransactions()
     * @property Plan $plan
     * @method BelongsTo|_IH_Plan_QB plan()
     * @property _IH_SubscriptionLog_C|SubscriptionLog[] $subscriptionLogs
     * @property-read int $subscription_logs_count
     * @method HasMany|_IH_SubscriptionLog_QB subscriptionLogs()
     * @property _IH_SubscriptionTransaction_C|SubscriptionTransaction[] $subscriptionTransactions
     * @property-read int $subscription_transactions_count
     * @method HasMany|_IH_SubscriptionTransaction_QB subscriptionTransactions()
     * @property User $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_Subscription_QB onWriteConnection()
     * @method _IH_Subscription_QB newQuery()
     * @method static _IH_Subscription_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_Subscription_QB query()
     * @method static _IH_Subscription_QB with(array|string $relations)
     * @method _IH_Subscription_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Subscription_C|Subscription[] all($columns = ['*'])
     * @ownLinks user_id,\App\Models\User,id|end_by,\App\Models\User,id|plan_id,\App\Models\Plan,id|payment_method_id,\App\Models\PaymentMethods,id
     * @foreignLinks id,\App\Models\SubscriptionTransaction,subscription_id|id,\App\Models\SubscriptionLog,subscription_id
     * @mixin _IH_Subscription_QB
     */
    class Subscription extends Model {}
    
    /**
     * @property int $id
     * @property string $uid
     * @property int $subscription_id
     * @property int|null $transaction_id
     * @property string|null $type
     * @property string|null $data
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Subscription $subscription
     * @method BelongsTo|_IH_Subscription_QB subscription()
     * @property SubscriptionTransaction $transaction
     * @method BelongsTo|_IH_SubscriptionTransaction_QB transaction()
     * @method static _IH_SubscriptionLog_QB onWriteConnection()
     * @method _IH_SubscriptionLog_QB newQuery()
     * @method static _IH_SubscriptionLog_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_SubscriptionLog_QB query()
     * @method static _IH_SubscriptionLog_QB with(array|string $relations)
     * @method _IH_SubscriptionLog_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_SubscriptionLog_C|SubscriptionLog[] all($columns = ['*'])
     * @ownLinks subscription_id,\App\Models\Subscription,id|transaction_id,\App\Models\SubscriptionTransaction,id
     * @mixin _IH_SubscriptionLog_QB
     */
    class SubscriptionLog extends Model {}
    
    /**
     * @property int $id
     * @property string $uid
     * @property int $subscription_id
     * @property string $title
     * @property string|null $type
     * @property string|null $status
     * @property string|null $amount
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Subscription $subscription
     * @method BelongsTo|_IH_Subscription_QB subscription()
     * @method static _IH_SubscriptionTransaction_QB onWriteConnection()
     * @method _IH_SubscriptionTransaction_QB newQuery()
     * @method static _IH_SubscriptionTransaction_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_SubscriptionTransaction_QB query()
     * @method static _IH_SubscriptionTransaction_QB with(array|string $relations)
     * @method _IH_SubscriptionTransaction_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_SubscriptionTransaction_C|SubscriptionTransaction[] all($columns = ['*'])
     * @ownLinks subscription_id,\App\Models\Subscription,id
     * @foreignLinks id,\App\Models\SubscriptionLog,transaction_id
     * @mixin _IH_SubscriptionTransaction_QB
     */
    class SubscriptionTransaction extends Model {}
    
    /**
     * @property int $id
     * @property string $uid
     * @property string $name
     * @property string $tag
     * @property string $type
     * @property bool $required
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_TemplateTags_QB onWriteConnection()
     * @method _IH_TemplateTags_QB newQuery()
     * @method static _IH_TemplateTags_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_TemplateTags_QB query()
     * @method static _IH_TemplateTags_QB with(array|string $relations)
     * @method _IH_TemplateTags_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_TemplateTags_C|TemplateTags[] all($columns = ['*'])
     * @mixin _IH_TemplateTags_QB
     */
    class TemplateTags extends Model {}
    
    /**
     * @property int $id
     * @property string $uid
     * @property int|null $user_id
     * @property string $name
     * @property string $message
     * @property bool $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property string|null $sender_id
     * @property string|null $dlt_template_id
     * @property string|null $dlt_category
     * @property string $approved
     * @property Senderid $senderid
     * @method BelongsTo|_IH_Senderid_QB senderid()
     * @property User|null $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_Templates_QB onWriteConnection()
     * @method _IH_Templates_QB newQuery()
     * @method static _IH_Templates_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_Templates_QB query()
     * @method static _IH_Templates_QB with(array|string $relations)
     * @method _IH_Templates_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Templates_C|Templates[] all($columns = ['*'])
     * @ownLinks user_id,\App\Models\User,id
     * @mixin _IH_Templates_QB
     */
    class Templates extends Model {}
    
    /**
     * @property int $id
     * @property string $uid
     * @property string|null $runtime_message_id
     * @property string|null $message_id
     * @property int $customer_id
     * @property int|null $sending_server_id
     * @property int|null $campaign_id
     * @property int $contact_id
     * @property int $contact_group_id
     * @property string|null $status
     * @property string|null $error
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property int|null $automation_id
     * @property int|null $sms_count
     * @property string|null $cost
     * @property Automation|null $automation
     * @method BelongsTo|_IH_Automation_QB automation()
     * @property Campaigns|null $campaign
     * @method BelongsTo|_IH_Campaigns_QB campaign()
     * @property Contacts $contact
     * @method BelongsTo|_IH_Contacts_QB contact()
     * @property ContactGroups $contactGroup
     * @method BelongsTo|_IH_ContactGroups_QB contactGroup()
     * @property User $customer
     * @method BelongsTo|_IH_User_QB customer()
     * @property SendingServer|null $sendingServer
     * @method BelongsTo|_IH_SendingServer_QB sendingServer()
     * @method static _IH_TrackingLog_QB onWriteConnection()
     * @method _IH_TrackingLog_QB newQuery()
     * @method static _IH_TrackingLog_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_TrackingLog_QB query()
     * @method static _IH_TrackingLog_QB with(array|string $relations)
     * @method _IH_TrackingLog_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_TrackingLog_C|TrackingLog[] all($columns = ['*'])
     * @ownLinks customer_id,\App\Models\User,id|sending_server_id,\App\Models\SendingServer,id|campaign_id,\App\Models\Campaigns,id|contact_id,\App\Models\Contacts,id|contact_group_id,\App\Models\ContactGroups,id|automation_id,\App\Models\Automation,id
     * @mixin _IH_TrackingLog_QB
     */
    class TrackingLog extends Model {}
    
    /**
     * @property int $id
     * @property string $uid
     * @property string|null $api_token
     * @property string $first_name
     * @property string|null $last_name
     * @property string $email
     * @property Carbon|null $email_verified_at
     * @property string|null $password
     * @property bool $status
     * @property string|null $image
     * @property string|null $sms_unit
     * @property bool $is_admin
     * @property bool $is_customer
     * @property string|null $active_portal
     * @property bool $two_factor
     * @property int|null $two_factor_code
     * @property Carbon|null $two_factor_expires_at
     * @property string|null $two_factor_backup_code
     * @property string $locale
     * @property string $timezone
     * @property Carbon|null $last_access_at
     * @property string|null $provider
     * @property string|null $provider_id
     * @property string|null $remember_token
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property int|null $api_sending_server
     * @property string|null $webhook_url
     * @property string|null $dlt_entity_id
     * @property string|null $dlt_telemarketer_id
     * @property int|null $parent_id
     * @property string|null $invitation_token
     * @property int|null $api_voice_sending_server
     * @property int|null $api_mms_sending_server
     * @property int|null $api_viber_sending_server
     * @property int|null $api_whatsapp_sending_server
     * @property int|null $api_otp_sending_server
     * @property-read bool $can_delete attribute
     * @property-read bool $can_edit attribute
     * @property-read bool $is_super_admin attribute
     * @property Admin $admin
     * @method HasOne|_IH_Admin_QB admin()
     * @property _IH_Announcements_C|Announcements[] $announcements
     * @property-read int $announcements_count
     * @method BelongsToMany|_IH_Announcements_QB announcements()
     * @property Customer $customer
     * @method HasOne|_IH_Customer_QB customer()
     * @property _IH_JobMonitor_C|JobMonitor[] $importJobs
     * @property-read int $import_jobs_count
     * @method HasMany|_IH_JobMonitor_QB importJobs()
     * @property _IH_JobMonitor_C|JobMonitor[] $jobMonitors
     * @property-read int $job_monitors_count
     * @method HasMany|_IH_JobMonitor_QB jobMonitors()
     * @property DatabaseNotificationCollection|DatabaseNotification[] $notifications
     * @property-read int $notifications_count
     * @method MorphToMany|_IH_DatabaseNotification_QB notifications()
     * @property User|null $parent
     * @method BelongsTo|_IH_User_QB parent()
     * @property DatabaseNotificationCollection|DatabaseNotification[] $readNotifications
     * @property-read int $read_notifications_count
     * @method MorphToMany|_IH_DatabaseNotification_QB readNotifications()
     * @property _IH_Role_C|Role[] $roles
     * @property-read int $roles_count
     * @method BelongsToMany|_IH_Role_QB roles()
     * @property _IH_CustomerBasedSendingServer_C|CustomerBasedSendingServer[] $sendingServers
     * @property-read int $sending_servers_count
     * @method HasMany|_IH_CustomerBasedSendingServer_QB sendingServers()
     * @property _IH_PersonalAccessToken_C|PersonalAccessToken[] $tokens
     * @property-read int $tokens_count
     * @method MorphToMany|_IH_PersonalAccessToken_QB tokens()
     * @property DatabaseNotificationCollection|DatabaseNotification[] $unreadNotifications
     * @property-read int $unread_notifications_count
     * @method MorphToMany|_IH_DatabaseNotification_QB unreadNotifications()
     * @method static _IH_User_QB onWriteConnection()
     * @method _IH_User_QB newQuery()
     * @method static _IH_User_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_User_QB query()
     * @method static _IH_User_QB with(array|string $relations)
     * @method _IH_User_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_User_C|User[] all($columns = ['*'])
     * @ownLinks api_sending_server,\App\Models\SendingServer,id|api_voice_sending_server,\App\Models\SendingServer,id|api_mms_sending_server,\App\Models\SendingServer,id|api_viber_sending_server,\App\Models\SendingServer,id|api_whatsapp_sending_server,\App\Models\SendingServer,id|api_otp_sending_server,\App\Models\SendingServer,id
     * @foreignLinks id,\App\Models\ContactGroups,customer_id|id,\App\Models\Contacts,customer_id|id,\App\Models\Currency,user_id|id,\App\Models\Customer,user_id|id,\App\Models\Plan,user_id|id,\App\Models\RoleUser,user_id|id,\App\Models\Subscription,user_id|id,\App\Models\Subscription,end_by|id,\App\Models\Keywords,user_id|id,\App\Models\Senderid,user_id|id,\App\Models\PhoneNumbers,user_id|id,\App\Models\Blacklists,user_id|id,\App\Models\Templates,user_id|id,\App\Models\Campaigns,user_id|id,\App\Models\Reports,user_id|id,\App\Models\Invoices,user_id|id,\App\Models\ChatBox,user_id|id,\App\Models\Notifications,user_id|id,\App\Models\TrackingLog,customer_id|id,\App\Models\ScheduleMessage,user_id|id,\App\Models\Automation,user_id|id,\App\Models\CustomerBasedPricingPlan,user_id|id,\App\Models\CustomerBasedSendingServer,user_id|id,\App\Models\FileCampaignData,user_id|id,\App\Models\Announcements,user_id|id,\Codeglen\Usupport\Models\SupportAgent,user_id|id,\Codeglen\Usupport\Models\SupportCategory,created_by|id,\Codeglen\Usupport\Models\SupportArticle,created_by|id,\Codeglen\Usupport\Models\SupportTicket,customer_id|id,\Codeglen\Usupport\Models\SupportTicket,agent_id|id,\Codeglen\Usupport\Models\SupportTicket,created_by|id,\Codeglen\Usupport\Models\SupportTicket,last_replied_by|id,\Codeglen\Usupport\Models\TicketReply,user_id|id,\App\Models\FailedContactImport,user_id|id,\Codeglen\Ulanding\Models\Blog,user_id|id,\Codeglen\Ulanding\Models\BlogComment,user_id|id,\App\Models\SendingServer,user_id|id,\App\Models\CsvData,user_id
     * @mixin _IH_User_QB
     */
    class User extends Model {}
}