<?php

    return [

        // Общие сообщения
        'something_went_wrong' => 'Что-то пошло не так. Пожалуйста, попробуйте позже.',
        'permission_denied'    => 'У вас нет прав для выполнения этого действия.',
        'operation_successful' => 'Операция успешно завершена!',

        // Глобальные ярлыки
        'last_modified'        => 'Последнее изменение',
        'description'          => 'Описание',
        'slug'                 => 'Slug',
        'is_active'            => 'Активен?',
        'add_new'              => 'Добавить новый',
        'edit'                 => 'Редактировать',
        'back_to_list'         => 'Назад к списку',
        'select_category'      => '-- Выберите категорию --',
        'uncategorized'        => 'Без категории',
        'unknown_user'         => 'Неизвестный пользователь',
        'confirm_delete_title' => 'Вы уверены?',
        'you'                  => 'Вы',
        'updated'              => 'Обновлено',

        // Кнопки
        'buttons'              => [
            'open'       => 'Открыть',
            'reply'      => 'Ответить',
            'publish'    => 'Опубликовать',
            'unpublish'  => 'Снять с публикации',
            'feature'    => 'Выделить',
            'unfeature'  => 'Снять выделение',
            'deactivate' => 'Деактивировать',
        ],

        /*
        |--------------------------------------------------------------------------
        | Настройки поддержки
        |--------------------------------------------------------------------------
        */
        'settings'             => [
            'support_desk_name'               => 'Название службы поддержки',
            'support_desk_name_help'          => 'Используется во всей системе поддержки, в письмах и т.д.',
            'support_desk_email'              => 'Email службы поддержки',
            'support_desk_email_help'         => 'Используется только для отправки важных уведомлений.',
            'title'                           => 'Настройки поддержки',
            'ticket_settings'                 => 'Настройки тикетов',
            'ticket_tags'                     => 'Теги тикетов',
            'privacy_settings'                => 'Настройки конфиденциальности',
            'important_notice_messages'       => 'Сообщения о важных уведомлениях',
            'auto_reassign'                   => 'Автоматически переназначать тикеты на агента, который ответил',
            'filter_by_category'              => 'Фильтровать список статей по категории в окне ответа на тикет',
            'disable_public_tickets'          => 'Отключить публичные тикеты <span class="text-muted small">(Текущие публичные тикеты не будут затронуты)</span>',
            'public_tickets_default'          => 'Публичные тикеты по умолчанию (вместо приватных)',
            'order_by_last_updated'           => 'Сортировать тикеты по дате последнего обновления по возрастанию',
            'group_by_last_updated'           => 'Группировать тикеты по дате последнего обновления',
            'enable_autoresponder'            => 'Включить автоответчик',
            'enable_important_notice_message' => 'Включить сообщение о важном уведомлении',
            'updated_successfully'            => 'Настройки успешно обновлены.',
            'ticket_tag_updated_successfully' => 'Тег тикета успешно обновлён.',
        ],

        /*
        |--------------------------------------------------------------------------
        | Агенты поддержки
        |--------------------------------------------------------------------------
        */
        'agents'               => [
            'open_tickets'                       => 'Открытые тикеты',
            'closed_tickets'                     => 'Закрытые тикеты',
            'last_signed_in'                     => 'Последний вход',
            'statistics'                         => 'Статистика',
            'assign_agent'                       => 'Назначить агента',
            'edit_agent'                         => 'Редактировать агента',
            'designation'                        => 'Должность',
            'bio'                                => 'Биография',
            'description'                        => 'Сначала создайте роль через <a href=":role_url" target="_blank">Создать роль</a>, затем создайте администратора через <a href=":administrator_url" target="_blank">Создать администратора</a>. Назначьте созданную роль администратору и, наконец, назначьте администратора агентом поддержки.',
            'assigned_successfully'              => 'Агент успешно назначен.',
            'already_assigned_or_no_change'      => 'Агент уже назначен или изменений не произошло.',
            'never_logged_in'                    => 'Никогда не входил',
            'confirm_activate_text'              => 'Вы действительно хотите активировать этих агентов?',
            'confirm_deactivate_text'            => 'Вы действительно хотите деактивировать этих агентов?',
            'confirm_delete_text'                => 'Вы действительно хотите снять этих агентов с роли агента поддержки?',
            'yes_activate_it'                    => 'Да, активировать!',
            'yes_deactivate_it'                  => 'Да, деактивировать!',
            'yes_release_it'                     => 'Да, снять!',
            'deactivated_successfully'           => 'Агент успешно деактивирован.',
            'updated_successfully'               => 'Агент успешно обновлён.',
            'deleted_successfully'               => 'Администратор успешно снят с роли агента поддержки.',
            'no_valid_selected_for_deactivation' => 'Нет выбранных действительных агентов для деактивации.',
            'activate_selected'                  => 'Активировать выбранное',
            'activated_multiple_successfully'    => ':count агентов успешно активированы.',
            'deactivate_selected'                => 'Деактивировать выбранное',
            'deactivated_multiple_successfully'  => ':count агентов успешно деактивированы.',
            'delete_selected'                    => 'Снять выбранное',
            'deleted_multiple_successfully'      => ':count агентов успешно сняты с роли агента поддержки.',
        ],


        /*
        |--------------------------------------------------------------------------
        | Категории поддержки
        |--------------------------------------------------------------------------
        */
        'categories'           => [
            'title_singular'                => 'Категория поддержки',
            'title_plural'                  => 'Категории поддержки',
            'name'                          => 'Название категории',
            'icon'                          => 'Иконка',
            'name_placeholder'              => 'например, Технические проблемы, Вопросы по оплате',
            'slug_placeholder'              => 'например, technical-issues',
            'description_placeholder'       => 'Краткое описание категории',
            'add_new'                       => 'Добавить категорию',
            'edit'                          => 'Редактировать категорию',
            'details'                       => 'Детали категории',
            'select_icon'                   => 'Выберите иконку',
            'search_icons'                  => 'Поиск иконок...',
            'created_successfully'          => 'Категория поддержки успешно создана!',
            'updated_successfully'          => 'Категория поддержки успешно обновлена!',
            'deleted_successfully'          => 'Категория поддержки успешно удалена!',
            'confirm_activate'              => 'Вы уверены, что хотите активировать выбранные категории?',
            'confirm_deactivate'            => 'Вы уверены, что хотите деактивировать выбранные категории?',
            'confirm_delete'                => 'Вы уверены, что хотите навсегда удалить выбранные категории?',
            'activated_successfully'        => ':count категорий успешно активированы.',
            'deactivated_successfully'      => ':count категорий успешно деактивированы.',
            'deleted_multiple_successfully' => ':count категорий успешно удалены.',
            'slug_auto_generated_help'      => 'Slug будет автоматически сгенерирован из названия, если оставить пустым.',
            'browse_by_category'            => 'Просмотр по категории',
            'published_on'                  => 'Опубликовано',
            'related_questions'             => 'Связанные вопросы',
        ],

        /*
        |--------------------------------------------------------------------------
        | Тикеты поддержки
        |--------------------------------------------------------------------------
        */
        'tickets'              => [
            'title_singular'                        => 'Тикет поддержки',
            'title_plural'                          => 'Тикеты поддержки',
            'create_ticket'                         => 'Создать тикет',
            'view_ticket'                           => 'Просмотр тикета',
            'created_successfully'                  => 'Тикет поддержки успешно создан!',
            'updated_successfully'                  => 'Тикет поддержки успешно обновлён!',
            'deleted_successfully'                  => 'Тикет поддержки успешно удалён!',
            'status_updated_successfully'           => 'Статус тикета успешно обновлён!',
            'assigned_successfully'                 => 'Тикет успешно назначен!',
            'tags_updated_successfully'             => 'Теги тикета успешно обновлены!',
            'confirm_action'                        => 'Вы собираетесь :action :length тикетов.',
            'opened_successfully'                   => ':count тикетов успешно открыты!',
            'closed_successfully'                   => ':count тикетов успешно закрыты!',
            'marked_pending_successfully'           => ':count тикетов успешно помечены как ожидающие!',
            'assigned_multiple_successfully'        => ':count тикетов успешно назначены :agent!',
            'deleted_multiple_successfully'         => ':count тикетов успешно удалены!',
            'starred_successfully'                  => 'Статус избранного тикета успешно обновлён!',
            'category'                              => 'Категория',
            'assigned_agent'                        => 'Назначенный агент',
            'last_replied'                          => 'Последний ответ',
            'priority'                              => 'Приоритет',
            'customer_name'                         => 'Имя клиента',
            'customer_email'                        => 'Email клиента',
            'please_select_an_agent_for_assignment' => 'Пожалуйста, выберите агента для назначения.',
            'search_placeholder'                    => 'Поиск тикетов...',
            'filter_by_status'                      => 'Фильтр по статусу',
            'filter_by_priority'                    => 'Фильтр по приоритету',
            'assigned_to'                           => 'Назначено :agent_name',
            'unassigned'                            => 'Не назначено',
            'last_updated'                          => 'Обновлено :time назад',
            'no_tickets_found'                      => 'Тикеты, соответствующие критериям, не найдены.',
            'category_help'                         => 'В какой категории вам нужна помощь?',
            'subject_help'                          => 'О чём в целом этот тикет?',
            'subject_placeholder'                   => 'О чём этот тикет?',
            'related_url'                           => 'Связанный URL',
            'related_url_help'                      => 'Необязательно, но очень полезно.',
            'description_help'                      => 'Пожалуйста, максимально подробно опишите детали тикета.',
            'description_placeholder'               => 'Чем мы можем вам помочь сегодня?',
            'agent_help'                            => 'При желании назначьте агента для этого тикета.',
            'select_agent'                          => 'Выберите агента',
            'file_type_not_allowed'                 => 'Тип файла не разрешён.',
            'file_extension_not_allowed'            => 'Расширение файла не разрешено.',
            'file_too_large'                        => 'Файл слишком большой. Максимальный размер :max.',
            'one_or_more_files_invalid'             => 'Один или несколько выбранных файлов недопустимы (тип или размер). Пожалуйста, проверьте и попробуйте снова.',
            'max_attachments_exceeded'              => 'Вы можете загрузить максимум :max вложений.',
            'make_public'                           => 'Сделать тикет публичным',
            'is_public_customer_notes'              => 'По умолчанию только команда поддержки может просматривать и отвечать на ваши тикеты.',
            'is_public_help'                        => '<i>Публичный тикет</i>, однако, позволит всей сообществу просматривать и отвечать. <b>Обратите внимание, что они не смогут видеть информацию из полей "приватно".</b>',
            'status_help'                           => 'Текущий статус тикета.',
            'select_status'                         => 'Выберите статус',
            'priority_help'                         => 'Уровень важности тикета.',
            'select_priority'                       => 'Выберите приоритет',
            'customer_help'                         => 'Выберите клиента, для которого создаётся тикет.',
            'select_customer'                       => 'Выберите клиента',
            'private_ticket'                        => 'ПРИВАТНЫЙ ТИКЕТ',
            'original_description'                  => 'Исходное описание тикета',
            'no_replies_yet'                        => 'Ответов или заметок ещё нет.',
            'post_a_reply'                          => 'Добавить ответ',
            'post_a_note'                           => 'Добавить заметку',
            'reply_placeholder'                     => 'Добавьте к этому разговору...',
            'private_note'                          => 'Приватная заметка',
            'internal_note'                         => 'Внутренняя заметка',
            'public_reply'                          => 'Публичный ответ',
            'post_reply'                            => 'Отправить ответ',
            'post_note'                             => 'Добавить заметку',
            'ticket_details'                        => 'ДЕТАЛИ ТИКЕТА',
            'contact'                               => 'Контакт',
            'assigned'                              => 'НАЗНАЧЕНО',
            'created'                               => 'СОЗДАНО',
            'response'                              => 'ОТВЕТ',
            'public_ticket'                         => 'ПУБЛИЧНЫЙ ТИКЕТ',
            'private'                               => 'Приватный',
            'public'                                => 'Публичный',
            'privately_reply'                       => 'Ответить приватно',
            'add_customer_note_btn'                 => 'Добавить заметку клиента',
            'no_response_yet'                       => 'Ответов пока нет',
            'delete_ticket'                         => 'Удалить этот тикет',
            'ticket_tags'                           => 'ТЕГИ ТИКЕТА',
            'select_some_options'                   => 'Выберите несколько опций',
            'reply_added_successfully'              => 'Ответ успешно добавлен!',
            'attachments'                           => 'Вложения',
            'needs_response'                        => 'Требуется ответ',
            'customer_notes'                        => 'Заметки клиента',
            'close_ticket'                          => 'Закрыть тикет',
            'ticket_closed_successfully'            => 'Тикет успешно закрыт!',
            'select_tags'                           => 'Выберите теги',
            'update_priority_successfully'          => 'Приоритет тикета успешно обновлён!',
            'category_updated_successfully'         => 'Категория тикета успешно обновлена!',
            'replied_privately'                     => 'Отвечено приватно',
            'privacy_policy_note'                   => 'Прочитайте нашу <a href=":privacy_policy_url" target="_blank">Политику конфиденциальности</a> и узнайте, как мы обрабатываем ваши данные',
            'all_cleared'                           => 'Все очищено.',

            'statuses'   => [
                'pending'    => 'В ожидании',
                'open'       => 'Открыт',
                'resolved'   => 'Решён',
                'closed'     => 'Закрыт',
                'replied'    => 'Ответ дан (-клиент)',
                'starred'    => 'Избранный',
                'unassigned' => 'Не назначен',
            ],
            'priorities' => [
                'low'    => 'Низкий',
                'medium' => 'Средний',
                'high'   => 'Высокий',
                'urgent' => 'Срочный',
            ],
            'filters'    => [
                'title'               => 'Фильтры',
                'all_tickets'         => 'Все тикеты',
                'my_tickets'          => 'Мои тикеты',
                'unassigned_tickets'  => 'Не назначенные тикеты',
                'starred_tickets'     => 'Избранные тикеты',
                'categories'          => 'Категории',
                'no_categories_found' => 'Категории не найдены',
                'agents'              => 'Агенты',
                'no_agents_found'     => 'Агенты не найдены',
            ],
            'stats'      => [
                'title'              => 'Быстрая статистика',
                'total_tickets'      => 'Всего тикетов',
                'open_tickets'       => 'Открытые тикеты',
                'closed_last_7_days' => 'Закрыто (последние 7 дней)',
                'closed_older_than'  => 'Старше 7 дней',
                'closed_other'       => 'В течение последних 7 дней (прочее)',
                'closed_2days'       => 'Обновлено 2 дня назад',
                'updated_today'      => 'Обновлено сегодня',
                'no_action_needed'   => 'Действия не требуются',
            ],
        ],


        /*
        |--------------------------------------------------------------------------
        | Ответы на тикеты
        |--------------------------------------------------------------------------
        */
        'replies'              => [
            'added_successfully'        => 'Ответ успешно добавлен!',
            'message'                   => 'Сообщение ответа',
            'add_reply'                 => 'Добавить ответ',
            'your_reply'                => 'Ваш ответ',
            'title_plural'              => 'Ответы',
            'edited'                    => 'Отредактировано',
            'note_updated_successfully' => 'Заметка успешно обновлена.',
            'fetched_successfully'      => 'Ответ успешно получен.',
            'not_found'                 => 'Ответ не принадлежит указанному тикету.',
            'updated_successfully'      => 'Ответ успешно обновлён.',
            'deleted_successfully'      => 'Ответ успешно удалён.',
            'delete_failed'             => 'Не удалось удалить ответ.',
        ],

        /*
        |--------------------------------------------------------------------------
        | Вложения тикетов
        |--------------------------------------------------------------------------
        */
        'attachments'          => [
            'title_plural'         => 'Вложения',
            'add_attachments'      => 'Добавить вложения',
            'not_found'            => 'Вложение не принадлежит указанному тикету.',
            'deleted_successfully' => 'Вложение успешно удалено!',
            'delete_failed'        => 'Не удалось удалить вложение.',
        ],

        /*
        |--------------------------------------------------------------------------
        | Теги тикетов
        |--------------------------------------------------------------------------
        */
        'tags'                 => [
            'title_singular'                => 'Тег тикета',
            'title_plural'                  => 'Теги тикетов',
            'name'                          => 'Название тега',
            'name_placeholder'              => 'Введите название тега',
            'description'                   => 'Описание тега',
            'color'                         => 'Цвет',
            'add_new'                       => 'Добавить новый тег',
            'edit'                          => 'Редактировать тег',
            'created_successfully'          => 'Тег успешно создан!',
            'updated_successfully'          => 'Тег успешно обновлён!',
            'deleted_successfully'          => 'Тег успешно удалён!',
            'deleted_multiple_successfully' => ':count тегов успешно удалены!',
        ],

        /*
        |--------------------------------------------------------------------------
        | Статьи поддержки
        |--------------------------------------------------------------------------
        */
        'articles'             => [
            'title_singular'             => 'Статья поддержки',
            'title_plural'               => 'Статьи поддержки',
            'create'                     => 'Создать статью поддержки',
            'edit'                       => 'Редактировать статью поддержки',
            'published_status'           => 'Статус публикации',
            'featured_status'            => 'Статус избранного',
            'draft'                      => 'Черновик',
            'published'                  => 'Опубликовано',
            'featured'                   => 'Избранное',
            'views'                      => 'Просмотры',
            'confirm_delete_text'        => 'Вы не сможете восстановить эту статью поддержки!',
            'deleted_successfully'       => 'Статья поддержки успешно удалена.',
            'delete_failed'              => 'Не удалось удалить статью поддержки.',
            'created_successfully'       => 'Статья поддержки успешно создана!',
            'updated_successfully'       => 'Статья поддержки успешно обновлена!',
            'update_failed'              => 'Не удалось обновить статью поддержки.',
            'published_successfully'     => 'Статья успешно опубликована.',
            'unpublished_successfully'   => 'Статья успешно снята с публикации.',
            'featured_successfully'      => 'Статья успешно добавлена в избранное.',
            'unfeatured_successfully'    => 'Статья успешно удалена из избранного.',
            'slug_help'                  => 'Оставьте пустым для автогенерации из заголовка. Должен быть уникальным.',
            'is_published_help'          => 'Снимите отметку, чтобы сохранить как черновик',
            'confirm_publish'            => 'Вы уверены, что хотите опубликовать выбранные статьи?',
            'confirm_unpublish'          => 'Вы уверены, что хотите снять с публикации выбранные статьи?',
            'confirm_feature'            => 'Вы уверены, что хотите выделить выбранные статьи как избранные?',
            'confirm_unfeature'          => 'Вы уверены, что хотите убрать выбранные статьи из избранного?',
            'confirm_delete'             => 'Вы уверены, что хотите навсегда удалить выбранные статьи?',
            'batch_action_success'       => ':count статей успешно :action.',
            'batch_action_failed'        => 'Не удалось выполнить групповое действие.',
            'batch_action_failed_no_ids' => 'Не удалось выполнить групповое действие. ID не предоставлены.',
            'help_text'                  => 'Добро пожаловать в поддержку! У нас есть :count статей, чтобы помочь вам',
            'search_placeholder'         => 'Ищите статьи помощи или часто задаваемые вопросы...',
            'read_article'               => 'Читать статью',
            'featured_articles'          => 'Избранные статьи',
            'most_viewed_articles'       => 'Наиболее просматриваемые статьи',
            'question'                   => 'Вопрос',
            'last_updated_on'            => 'Последнее обновление',
        ],

        /*
        |--------------------------------------------------------------------------
        | Массовые действия - Общие сообщения для всех массовых действий
        |--------------------------------------------------------------------------
        */
        'batch_actions'        => [
            'select_action'                         => 'Выберите массовое действие',
            'select_action_warning'                 => 'Пожалуйста, выберите массовое действие.',
            'select_items_warning'                  => 'Пожалуйста, выберите хотя бы один элемент.',
            'confirm_title'                         => 'Вы уверены?',
            'confirm_text'                          => 'Вы собираетесь выполнить массовое действие: :action для выбранных элементов.',
            'you_will_be_able_to_revert_this_later' => 'Вы не сможете отменить это позже.',
            'bulk_actions'                          => 'Массовые действия',
        ],
        /*
        |--------------------------------------------------------------------------
        | Аналитика поддержки
        |--------------------------------------------------------------------------
        */

        'analytics' => [
            'new_tickets'              => 'Новые тикеты',
            'agent_responses'          => 'Ответы агентов',
            'resolved_tickets'         => 'Решённые тикеты',
            'analytics_overview'       => 'Обзор аналитики',
            'all_categories'           => 'Все категории',
            'all_agents'               => 'Все агенты',
            'apply_filters'            => 'Применить фильтры',
            'no_change_from_yesterday' => 'Без изменений по сравнению с вчера',
            'from_yesterday'           => 'С вчера',
            'agent_replies'            => 'Ответы агентов',
            'updated'                  => 'Данные аналитики успешно обновлены!',
            'date_range'               => 'Диапазон дат',
            'select_date_range'        => 'Выберите диапазон дат',
            'agent'                    => 'Агент',
        ],

        /*
        |--------------------------------------------------------------------------
        | Сообщения об отказе политики
        |--------------------------------------------------------------------------
        |
        | Эти сообщения возвращаются политиками, когда авторизация не прошла.
        |
        */
        'policies'  => [
            'support_categories' => [
                'view_any'     => 'У вас нет разрешения на просмотр категорий поддержки.',
                'view'         => 'У вас нет разрешения на просмотр этой категории поддержки.',
                'create'       => 'У вас нет разрешения на создание категорий поддержки.',
                'update'       => 'У вас нет разрешения на обновление этой категории поддержки.',
                'delete'       => 'У вас нет разрешения на удаление этой категории поддержки.',
                'delete_any'   => 'У вас нет разрешения на удаление нескольких категорий поддержки.',
                'batch_action' => 'У вас нет разрешения на выполнение массовых действий с категориями поддержки.',
            ],
            'support_articles'   => [
                'view_any'     => 'У вас нет разрешения на просмотр статей поддержки.',
                'view'         => 'У вас нет разрешения на просмотр этой статьи поддержки.',
                'create'       => 'У вас нет разрешения на создание статей поддержки.',
                'update'       => 'У вас нет разрешения на обновление этой статьи поддержки.',
                'delete'       => 'У вас нет разрешения на удаление этой статьи поддержки.',
                'delete_any'   => 'У вас нет разрешения на удаление нескольких статей поддержки.',
                'batch_action' => 'У вас нет разрешения на выполнение массовых действий со статьями поддержки.',
                'publish'      => 'У вас нет разрешения на публикацию или снятие с публикации этой статьи поддержки.',
                'feature'      => 'У вас нет разрешения на выделение или снятие выделения этой статьи поддержки.',
            ],

            'support_tickets'    => [
                'view_any'      => 'У вас нет разрешения на просмотр тикетов поддержки.',
                'view'          => 'У вас нет разрешения на просмотр этого тикета.',
                'create'        => 'У вас нет разрешения на создание тикетов поддержки.',
                'update'        => 'У вас нет разрешения на обновление этого тикета.',
                'delete'        => 'У вас нет разрешения на удаление этого тикета.',
                'reply'         => 'У вас нет разрешения на ответ на этот тикет или он закрыт.',
                'update_status' => 'У вас нет разрешения на изменение статуса этого тикета.',
                'assign'        => 'У вас нет разрешения на назначение этого тикета.',
                'manage_tags'   => 'У вас нет разрешения на управление тегами этого тикета.',
                'delete_any'    => 'У вас нет разрешения на удаление нескольких тикетов поддержки.',
                'batch_action'  => 'У вас нет разрешения на выполнение массовых действий с тикетами поддержки.',
            ],
            'ticket_replies'     => [
                'update'     => 'У вас нет разрешения на редактирование этого ответа, или срок редактирования истёк.',
                'delete'     => 'У вас нет разрешения на удаление этого ответа.',
                'delete_any' => 'У вас нет разрешения на удаление нескольких ответов на тикеты.',
            ],
            'ticket_attachments' => [
                'view'       => 'У вас нет разрешения на просмотр этого вложения.',
                'delete'     => 'У вас нет разрешения на удаление этого вложения.',
                'delete_any' => 'У вас нет разрешения на удаление нескольких вложений тикетов.',
            ],
        ],


    ];
